package com.xforceplus.policymanagement.controller;


/**
 * 系统消息模块对象feign客户端
 *
 * @author ultraman
 * @date 2024-11-15
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.SystemMessageModule;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface SystemMessageModuleFeignApi {

  /**
   * 通过id查询系统消息模块对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemMessageModule/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增系统消息模块对象
   * @param systemMessageModule 系统消息模块对象
   * @return R
   */
  @PostMapping("/systemMessageModule/add")
  public R save(@RequestBody SystemMessageModule systemMessageModule);

  /**
   * 修改系统消息模块对象
   * @param systemMessageModule 系统消息模块对象
   * @return R
   */
  @PostMapping("/systemMessageModule/update")
  public R updateById(@RequestBody SystemMessageModule systemMessageModule);

  /**
   * 通过id删除系统消息模块对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemMessageModule/del/{id}" )
  public R removeById(@PathVariable Long id);

}