package com.xforceplus.policymanagement.controller;


/**
 * 组织系统对象feign客户端
 *
 * @author ultraman
 * @date 2024-11-15
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.SystemOrg;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface SystemOrgFeignApi {

  /**
   * 通过id查询组织系统对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemOrg/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增组织系统对象
   * @param systemOrg 组织系统对象
   * @return R
   */
  @PostMapping("/systemOrg/add")
  public R save(@RequestBody SystemOrg systemOrg);

  /**
   * 修改组织系统对象
   * @param systemOrg 组织系统对象
   * @return R
   */
  @PostMapping("/systemOrg/update")
  public R updateById(@RequestBody SystemOrg systemOrg);

  /**
   * 通过id删除组织系统对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemOrg/del/{id}" )
  public R removeById(@PathVariable Long id);

}