package com.xforceplus.policymanagement.controller;


/**
 * 角色系统对象feign客户端
 *
 * @author ultraman
 * @date 2024-11-15
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.SystemRole;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "policy-management")
public interface SystemRoleFeignApi {

  /**
   * 通过id查询角色系统对象
   * @param  id
   * @return R
   */
  @GetMapping("/systemRole/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增角色系统对象
   * @param systemRole 角色系统对象
   * @return R
   */
  @PostMapping("/systemRole/add")
  public R save(@RequestBody SystemRole systemRole);

  /**
   * 修改角色系统对象
   * @param systemRole 角色系统对象
   * @return R
   */
  @PostMapping("/systemRole/update")
  public R updateById(@RequestBody SystemRole systemRole);

  /**
   * 通过id删除角色系统对象
   * @param  id
   * @return R
   */
  @DeleteMapping("/systemRole/del/{id}" )
  public R removeById(@PathVariable Long id);

}