package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * documents_type
 * </p>
 *
 * @author ultraman
 * @since 2024-10-31
 */
public enum DocumentsType {

    _1("1", "汇总应收单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DocumentsType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DocumentsType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
