package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_order_types
 * </p>
 *
 * @author ultraman
 * @since 2024-10-31
 */
public enum DyOrderTypes {

    _0("0", "普通订单"),
    _2("2", "虚拟商品订单"),
    _4("4", "电子券（poi核销）"),
    _5("5", "三方核销");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DyOrderTypes(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyOrderTypes fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "2":
                return _2;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
