package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ec_channel
 * </p>
 *
 * @author ultraman
 * @since 2024-10-31
 */
public enum EcChannel {

    TM("TM", "天猫"),
    JD("JD", "京东"),
    PDD("PDD", "拼多多"),
    DY("DY", "抖音"),
    KS("KS", "快手");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    EcChannel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EcChannel fromCode(String code){
        switch(code) {
            case "TM":
                return TM;
            case "JD":
                return JD;
            case "PDD":
                return PDD;
            case "DY":
                return DY;
            case "KS":
                return KS;
            default:
                return null;
        }
    }
}
