package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * jky_invoice_type
 * </p>
 *
 * @author ultraman
 * @since 2024-10-31
 */
public enum JkyInvoiceType {

    _0("0", "无"),
    _1("1", "增值税电子普通发票"),
    _2("2", "增值税普通发票"),
    _3("3", "增值税专用发票"),
    _4("4", "增值税电子专用发票"),
    _5("5", "普通发票（全电）"),
    _6("6", "专用发票（全电）");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    JkyInvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JkyInvoiceType fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
