package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * jky_trade_from
 * </p>
 *
 * @author ultraman
 * @since 2024-10-31
 */
public enum JkyTradeFrom {

    _1("1", "网店下载"),
    _2("2", "手工新建"),
    _3("3", "订单导入"),
    _4("4", "吉商城"),
    _7("7", "门店"),
    _8("8", "分销"),
    _9("9", "吉链采购"),
    _10("10", "吉链分销"),
    _11("11", "吉商城分销"),
    _12("12", "奇门分销"),
    _13("13", "销售返利"),
    _14("14", "门店补货"),
    _6("6", "售后");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    JkyTradeFrom(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JkyTradeFrom fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
