package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * oms_trade_status
 * </p>
 *
 * @author ultraman
 * @since 2024-10-31
 */
public enum OmsTradeStatus {

    _8("8", "状态1"),
    _11("11", "状态2");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OmsTradeStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OmsTradeStatus fromCode(String code){
        switch(code) {
            case "8":
                return _8;
            case "11":
                return _11;
            default:
                return null;
        }
    }
}
