package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * plugin_code
 * </p>
 *
 * @author ultraman
 * @since 2024-10-31
 */
public enum PluginCode {

    BUSINESS_NO("business_no", "businessNo"),
    MAIN_TAG("main_tag", "mainTag"),
    SINK_JANUS("sink_janus", "sinkJanus");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PluginCode(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PluginCode fromCode(String code){
        switch(code) {
            case "business_no":
                return BUSINESS_NO;
            case "main_tag":
                return MAIN_TAG;
            case "sink_janus":
                return SINK_JANUS;
            default:
                return null;
        }
    }
}
