package com.xforceplus.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-10-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Jiageguanlidetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 事业部
   */
  private String businessGroup;

  /**
   * 公司名称
   */
  private String companyName;

  /**
   * 公司税号
   */
  private String taxNo;

  /**
   * 开票价
   */
  private BigDecimal detailBillingPrice;

  /**
   * 零售价
   */
  private BigDecimal detailSellingPrice;

  /**
   * 成本价
   */
  private BigDecimal detailCosts;

  /**
   * 扩展字段1
   */
  private String jiagezhuext1;

  /**
   * 扩展字段2
   */
  private String jiagezhuext2;

  /**
   * 扩展字段3
   */
  private String jiagezhuext3;

  /**
   * 扩展字段4
   */
  private String jiagezhuext4;

  /**
   * 扩展字段5
   */
  private String jiagezhuext5;

  /**
   * 扩展字段6
   */
  private BigDecimal jiagezhuext6;

  /**
   * 扩展字段7
   */
  private BigDecimal jiagezhuext7;

  /**
   * 扩展字段8
   */
  private BigDecimal jiagezhuext8;

  /**
   * 扩展字段9
   */
  private BigDecimal jiagezhuext9;

  /**
   * 扩展字段10
   */
  private BigDecimal jiagezhuext10;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;


  /**
   * 对一关联关系 关联对象 jiageguanlimain
   */
    private Long jiageguanliRelationId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("business_group", businessGroup);
      map.put("company_name", companyName);
      map.put("tax_no", taxNo);
      map.put("detail_billing_price", detailBillingPrice);
      map.put("detail_selling_price", detailSellingPrice);
      map.put("detail_costs", detailCosts);
      map.put("jiagezhuext_1", jiagezhuext1);
      map.put("jiagezhuext_2", jiagezhuext2);
      map.put("jiagezhuext_3", jiagezhuext3);
      map.put("jiagezhuext_4", jiagezhuext4);
      map.put("jiagezhuext_5", jiagezhuext5);
      map.put("jiagezhuext_6", jiagezhuext6);
      map.put("jiagezhuext_7", jiagezhuext7);
      map.put("jiagezhuext_8", jiagezhuext8);
      map.put("jiagezhuext_9", jiagezhuext9);
      map.put("jiagezhuext_10", jiagezhuext10);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

       map.put("jiageguanliRelation.id", jiageguanliRelationId);
      return map;
  }

  public static Jiageguanlidetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Jiageguanlidetail entity = new Jiageguanlidetail();
    if(map.containsKey("business_group")) {
      Object obj = map.get("business_group");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_no")) {
      Object obj = map.get("tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("detail_billing_price")) {
      Object obj = map.get("detail_billing_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDetailBillingPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDetailBillingPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDetailBillingPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDetailBillingPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDetailBillingPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("detail_selling_price")) {
      Object obj = map.get("detail_selling_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDetailSellingPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDetailSellingPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDetailSellingPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDetailSellingPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDetailSellingPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("detail_costs")) {
      Object obj = map.get("detail_costs");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDetailCosts((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDetailCosts(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDetailCosts(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDetailCosts(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDetailCosts(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_1")) {
      Object obj = map.get("jiagezhuext_1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiagezhuext1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_2")) {
      Object obj = map.get("jiagezhuext_2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiagezhuext2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_3")) {
      Object obj = map.get("jiagezhuext_3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiagezhuext3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_4")) {
      Object obj = map.get("jiagezhuext_4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiagezhuext4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_5")) {
      Object obj = map.get("jiagezhuext_5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiagezhuext5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_6")) {
      Object obj = map.get("jiagezhuext_6");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJiagezhuext6((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJiagezhuext6(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJiagezhuext6(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJiagezhuext6(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJiagezhuext6(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_7")) {
      Object obj = map.get("jiagezhuext_7");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJiagezhuext7((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJiagezhuext7(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJiagezhuext7(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJiagezhuext7(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJiagezhuext7(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_8")) {
      Object obj = map.get("jiagezhuext_8");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJiagezhuext8((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJiagezhuext8(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJiagezhuext8(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJiagezhuext8(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJiagezhuext8(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_9")) {
      Object obj = map.get("jiagezhuext_9");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJiagezhuext9((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJiagezhuext9(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJiagezhuext9(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJiagezhuext9(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJiagezhuext9(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jiagezhuext_10")) {
      Object obj = map.get("jiagezhuext_10");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJiagezhuext10((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJiagezhuext10(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJiagezhuext10(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJiagezhuext10(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJiagezhuext10(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("jiageguanliRelation.id")) {
        Object obj = map.get("jiageguanliRelation.id");
      if(obj instanceof Long) {
        entity.setJiageguanliRelationId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setJiageguanliRelationId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("business_group")) {
      Object obj = map.get("business_group");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_no")) {
      Object obj = map.get("tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("detail_billing_price")) {
      Object obj = map.get("detail_billing_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDetailBillingPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDetailBillingPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDetailBillingPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDetailBillingPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDetailBillingPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("detail_selling_price")) {
      Object obj = map.get("detail_selling_price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDetailSellingPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDetailSellingPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDetailSellingPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDetailSellingPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDetailSellingPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("detail_costs")) {
      Object obj = map.get("detail_costs");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDetailCosts((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDetailCosts(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDetailCosts(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDetailCosts(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDetailCosts(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("jiagezhuext_1")) {
      Object obj = map.get("jiagezhuext_1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJiagezhuext1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jiagezhuext_2")) {
      Object obj = map.get("jiagezhuext_2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJiagezhuext2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jiagezhuext_3")) {
      Object obj = map.get("jiagezhuext_3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJiagezhuext3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jiagezhuext_4")) {
      Object obj = map.get("jiagezhuext_4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJiagezhuext4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jiagezhuext_5")) {
      Object obj = map.get("jiagezhuext_5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJiagezhuext5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jiagezhuext_6")) {
      Object obj = map.get("jiagezhuext_6");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setJiagezhuext6((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setJiagezhuext6(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setJiagezhuext6(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJiagezhuext6(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setJiagezhuext6(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("jiagezhuext_7")) {
      Object obj = map.get("jiagezhuext_7");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setJiagezhuext7((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setJiagezhuext7(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setJiagezhuext7(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJiagezhuext7(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setJiagezhuext7(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("jiagezhuext_8")) {
      Object obj = map.get("jiagezhuext_8");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setJiagezhuext8((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setJiagezhuext8(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setJiagezhuext8(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJiagezhuext8(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setJiagezhuext8(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("jiagezhuext_9")) {
      Object obj = map.get("jiagezhuext_9");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setJiagezhuext9((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setJiagezhuext9(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setJiagezhuext9(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJiagezhuext9(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setJiagezhuext9(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("jiagezhuext_10")) {
      Object obj = map.get("jiagezhuext_10");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setJiagezhuext10((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setJiagezhuext10(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setJiagezhuext10(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJiagezhuext10(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setJiagezhuext10(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("jiageguanliRelation.id")) {
        Object obj = map.get("jiageguanliRelation.id");
        if(obj instanceof Long) {
          this.setJiageguanliRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJiageguanliRelationId(Long.parseLong((String)obj));
        }
      }
  }
}
