package com.xforceplus.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-10-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class KsAfterSale implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 快手ID
   */
  private String ksId;

  /**
   * 租户code
   */
  private String ksTenantCode;

  /**
   * 店铺编号
   */
  private String storeId;

  /**
   * 获取账单日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime acqBillDate;

  /**
   * 订单编号
   */
  private String orderId;

  /**
   * 超售后期退款单号
   */
  private String refundNo;

  /**
   * 交易成功时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime tradeSuccessTime;

  /**
   * 退款申请时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime refundApplyTime;

  /**
   * 退款成功时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime refundFinishTime;

  /**
   * 创建退款成功时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtRefundFinishTime;

  /**
   * 结算时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settlementTime;

  /**
   * 二创机构追回状态
   */
  private String shortVideoStatus;

  /**
   * 平台TR追回时间
   */
  private BigDecimal platformTime;

  /**
   * 二级团长追回状态
   */
  private String secondActivityUserStatus;

  /**
   * 平台TR应追回金额
   */
  private BigDecimal platformAmount;

  /**
   * 用户实际付款金额
   */
  private BigDecimal actualPayAmount;

  /**
   * 快赚客应追回金额
   */
  private BigDecimal kzkAmount;

  /**
   * 达人退给平台金额
   */
  private BigDecimal distributorCommision;

  /**
   * 二创作者追回金额
   */
  private BigDecimal cutterAmount;

  /**
   * 运费退款金额
   */
  private BigDecimal freightRefundAmount;

  /**
   * 二级团长追回时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime secondActivityUserCompleteTime;

  /**
   * 达人追回状态
   */
  private String distributorStatus;

  /**
   * 二级团长追回金额
   */
  private BigDecimal secondActivityUserAmount;

  /**
   * 服务商应追回金额
   */
  private BigDecimal serviceAmount;

  /**
   * 二创作者追回状态
   */
  private BigDecimal cutterStatus;

  /**
   * 平台补贴退款金额
   */
  private BigDecimal platformAllowanceRefundAmount;

  /**
   * 团长追回时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime activityUserCompleteTime;

  /**
   * 团长追回时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime secondActivityUserCommision;

  /**
   * 团长应追回金额
   */
  private BigDecimal activityUserAmount;

  /**
   * 货款退款金额
   */
  private BigDecimal refundAmount;

  /**
   * 快赚客追回状态
   */
  private String kzkStatus;

  /**
   * 团长退给平台金额
   */
  private BigDecimal activityUserCommision;

  /**
   * 平台补贴
   */
  private BigDecimal platformAllowanceAmount;

  /**
   * 是否需要追回
   */
  private Boolean recover;

  /**
   * 达人tr退回金额
   */
  private BigDecimal distributorTrAmount;

  /**
   * 不追回原因
   */
  private String noRecoverReason;

  /**
   * 二创作者追回时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime cutterCompleteTime;

  /**
   * 团长追回状态
   */
  private String activityUserStatus;

  /**
   * 服务商追回时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime serviceCompleteTime;

  /**
   * 服务商追回时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime shortVideoCompleteTime;

  /**
   * 二创作者追回金额
   */
  private BigDecimal shortVideoAmount;

  /**
   * 达人应追回金额
   */
  private BigDecimal distributorAmount;

  /**
   * 技术服务费实收
   */
  private BigDecimal sellerPlatformCommissionAmount;

  /**
   * 主播补贴款金额
   */
  private BigDecimal anchorHongBaoAmount;

  /**
   * 服务商追回状态
   */
  private String serviceStatus;

  /**
   * 平台TR追回状态
   */
  private String platformStatus;

  /**
   * 达人追回时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime distributorCompleteTime;

  /**
   * 快赚客追回时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime kzkCompleteTime;

  /**
   * MCN机构ID
   */
  private String mcnId;

  /**
   * MCN机构追回金额
   */
  private BigDecimal mcnRecoverAmount;

  /**
   * MCN机构追回成功时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime mcnRecoverTime;

  /**
   * MCN机构追回状态
   */
  private String mcnRecoverStatus;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;

  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModified;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 单据流转处理状态
   */
  private String dealStatus;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("ks_id", ksId);
      map.put("ks_tenant_code", ksTenantCode);
      map.put("store_id", storeId);
      map.put("acq_bill_date", BocpGenUtils.toTimestamp(acqBillDate));
      map.put("order_id", orderId);
      map.put("refund_no", refundNo);
      map.put("trade_success_time", BocpGenUtils.toTimestamp(tradeSuccessTime));
      map.put("refund_apply_time", BocpGenUtils.toTimestamp(refundApplyTime));
      map.put("refund_finish_time", BocpGenUtils.toTimestamp(refundFinishTime));
      map.put("gmt_refund_finish_time", BocpGenUtils.toTimestamp(gmtRefundFinishTime));
      map.put("settlement_time", BocpGenUtils.toTimestamp(settlementTime));
      map.put("short_video_status", shortVideoStatus);
      map.put("platform_time", platformTime);
      map.put("second_activity_user_status", secondActivityUserStatus);
      map.put("platform_amount", platformAmount);
      map.put("actual_pay_amount", actualPayAmount);
      map.put("kzk_amount", kzkAmount);
      map.put("distributor_commision", distributorCommision);
      map.put("cutter_amount", cutterAmount);
      map.put("freight_refund_amount", freightRefundAmount);
      map.put("second_activity_user_complete_time", BocpGenUtils.toTimestamp(secondActivityUserCompleteTime));
      map.put("distributor_status", distributorStatus);
      map.put("second_activity_user_amount", secondActivityUserAmount);
      map.put("service_amount", serviceAmount);
      map.put("cutter_status", cutterStatus);
      map.put("platform_allowance_refund_amount", platformAllowanceRefundAmount);
      map.put("activity_user_complete_time", BocpGenUtils.toTimestamp(activityUserCompleteTime));
      map.put("second_activity_user_commision", BocpGenUtils.toTimestamp(secondActivityUserCommision));
      map.put("activity_user_amount", activityUserAmount);
      map.put("refund_amount", refundAmount);
      map.put("kzk_status", kzkStatus);
      map.put("activity_user_commision", activityUserCommision);
      map.put("platform_allowance_amount", platformAllowanceAmount);
      map.put("recover", recover);
      map.put("distributor_tr_amount", distributorTrAmount);
      map.put("no_recover_reason", noRecoverReason);
      map.put("cutter_complete_time", BocpGenUtils.toTimestamp(cutterCompleteTime));
      map.put("activity_user_status", activityUserStatus);
      map.put("service_complete_time", BocpGenUtils.toTimestamp(serviceCompleteTime));
      map.put("short_video_complete_time", BocpGenUtils.toTimestamp(shortVideoCompleteTime));
      map.put("short_video_amount", shortVideoAmount);
      map.put("distributor_amount", distributorAmount);
      map.put("seller_platform_commission_amount", sellerPlatformCommissionAmount);
      map.put("anchor_hong_bao_amount", anchorHongBaoAmount);
      map.put("service_status", serviceStatus);
      map.put("platform_status", platformStatus);
      map.put("distributor_complete_time", BocpGenUtils.toTimestamp(distributorCompleteTime));
      map.put("kzk_complete_time", BocpGenUtils.toTimestamp(kzkCompleteTime));
      map.put("mcn_id", mcnId);
      map.put("mcn_recover_amount", mcnRecoverAmount);
      map.put("mcn_recover_time", BocpGenUtils.toTimestamp(mcnRecoverTime));
      map.put("mcn_recover_status", mcnRecoverStatus);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("gmt_modified", BocpGenUtils.toTimestamp(gmtModified));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("deal_status", dealStatus);
      map.put("org_tree", orgTree);

      return map;
  }

  public static KsAfterSale fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    KsAfterSale entity = new KsAfterSale();
    if(map.containsKey("ks_id")) {
      Object obj = map.get("ks_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKsId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ks_tenant_code")) {
      Object obj = map.get("ks_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKsTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAcqBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAcqBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAcqBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAcqBillDate(null);
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_no")) {
      Object obj = map.get("refund_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_success_time")) {
      Object obj = map.get("trade_success_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTradeSuccessTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTradeSuccessTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTradeSuccessTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTradeSuccessTime(null);
      }
    }
    if(map.containsKey("refund_apply_time")) {
      Object obj = map.get("refund_apply_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRefundApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRefundApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRefundApplyTime(null);
      }
    }
    if(map.containsKey("refund_finish_time")) {
      Object obj = map.get("refund_finish_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRefundFinishTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRefundFinishTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundFinishTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRefundFinishTime(null);
      }
    }
    if(map.containsKey("gmt_refund_finish_time")) {
      Object obj = map.get("gmt_refund_finish_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtRefundFinishTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtRefundFinishTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtRefundFinishTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtRefundFinishTime(null);
      }
    }
    if(map.containsKey("settlement_time")) {
      Object obj = map.get("settlement_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettlementTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSettlementTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettlementTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettlementTime(null);
      }
    }
    if(map.containsKey("short_video_status")) {
      Object obj = map.get("short_video_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShortVideoStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("platform_time")) {
      Object obj = map.get("platform_time");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatformTime((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatformTime(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatformTime(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPlatformTime(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatformTime(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("second_activity_user_status")) {
      Object obj = map.get("second_activity_user_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSecondActivityUserStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("platform_amount")) {
      Object obj = map.get("platform_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatformAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatformAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatformAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPlatformAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatformAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("actual_pay_amount")) {
      Object obj = map.get("actual_pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActualPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActualPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActualPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActualPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActualPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("kzk_amount")) {
      Object obj = map.get("kzk_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setKzkAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setKzkAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setKzkAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setKzkAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setKzkAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("distributor_commision")) {
      Object obj = map.get("distributor_commision");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDistributorCommision((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDistributorCommision(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDistributorCommision(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDistributorCommision(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDistributorCommision(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cutter_amount")) {
      Object obj = map.get("cutter_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCutterAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCutterAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCutterAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCutterAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCutterAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("freight_refund_amount")) {
      Object obj = map.get("freight_refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFreightRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFreightRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFreightRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFreightRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFreightRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("second_activity_user_complete_time")) {
      Object obj = map.get("second_activity_user_complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSecondActivityUserCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSecondActivityUserCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSecondActivityUserCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSecondActivityUserCompleteTime(null);
      }
    }
    if(map.containsKey("distributor_status")) {
      Object obj = map.get("distributor_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistributorStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("second_activity_user_amount")) {
      Object obj = map.get("second_activity_user_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSecondActivityUserAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSecondActivityUserAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSecondActivityUserAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSecondActivityUserAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSecondActivityUserAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("service_amount")) {
      Object obj = map.get("service_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setServiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setServiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setServiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setServiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setServiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cutter_status")) {
      Object obj = map.get("cutter_status");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCutterStatus((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCutterStatus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCutterStatus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCutterStatus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCutterStatus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platform_allowance_refund_amount")) {
      Object obj = map.get("platform_allowance_refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatformAllowanceRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatformAllowanceRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatformAllowanceRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPlatformAllowanceRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatformAllowanceRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("activity_user_complete_time")) {
      Object obj = map.get("activity_user_complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setActivityUserCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setActivityUserCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActivityUserCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setActivityUserCompleteTime(null);
      }
    }
    if(map.containsKey("second_activity_user_commision")) {
      Object obj = map.get("second_activity_user_commision");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSecondActivityUserCommision(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSecondActivityUserCommision((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSecondActivityUserCommision(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSecondActivityUserCommision(null);
      }
    }
    if(map.containsKey("activity_user_amount")) {
      Object obj = map.get("activity_user_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActivityUserAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActivityUserAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActivityUserAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActivityUserAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActivityUserAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("refund_amount")) {
      Object obj = map.get("refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("kzk_status")) {
      Object obj = map.get("kzk_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKzkStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("activity_user_commision")) {
      Object obj = map.get("activity_user_commision");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setActivityUserCommision((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setActivityUserCommision(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setActivityUserCommision(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActivityUserCommision(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setActivityUserCommision(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("platform_allowance_amount")) {
      Object obj = map.get("platform_allowance_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatformAllowanceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatformAllowanceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatformAllowanceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPlatformAllowanceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatformAllowanceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("recover")) {
      Object obj = map.get("recover");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setRecover((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRecover(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("distributor_tr_amount")) {
      Object obj = map.get("distributor_tr_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDistributorTrAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDistributorTrAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDistributorTrAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDistributorTrAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDistributorTrAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("no_recover_reason")) {
      Object obj = map.get("no_recover_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNoRecoverReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cutter_complete_time")) {
      Object obj = map.get("cutter_complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCutterCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCutterCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCutterCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCutterCompleteTime(null);
      }
    }
    if(map.containsKey("activity_user_status")) {
      Object obj = map.get("activity_user_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setActivityUserStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("service_complete_time")) {
      Object obj = map.get("service_complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setServiceCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setServiceCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setServiceCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setServiceCompleteTime(null);
      }
    }
    if(map.containsKey("short_video_complete_time")) {
      Object obj = map.get("short_video_complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setShortVideoCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setShortVideoCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShortVideoCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setShortVideoCompleteTime(null);
      }
    }
    if(map.containsKey("short_video_amount")) {
      Object obj = map.get("short_video_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShortVideoAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShortVideoAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShortVideoAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShortVideoAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShortVideoAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("distributor_amount")) {
      Object obj = map.get("distributor_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDistributorAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDistributorAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDistributorAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDistributorAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDistributorAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("seller_platform_commission_amount")) {
      Object obj = map.get("seller_platform_commission_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSellerPlatformCommissionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSellerPlatformCommissionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSellerPlatformCommissionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerPlatformCommissionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerPlatformCommissionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("anchor_hong_bao_amount")) {
      Object obj = map.get("anchor_hong_bao_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAnchorHongBaoAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAnchorHongBaoAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAnchorHongBaoAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAnchorHongBaoAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAnchorHongBaoAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("service_status")) {
      Object obj = map.get("service_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setServiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("platform_status")) {
      Object obj = map.get("platform_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlatformStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distributor_complete_time")) {
      Object obj = map.get("distributor_complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDistributorCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDistributorCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDistributorCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDistributorCompleteTime(null);
      }
    }
    if(map.containsKey("kzk_complete_time")) {
      Object obj = map.get("kzk_complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setKzkCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setKzkCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setKzkCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setKzkCompleteTime(null);
      }
    }
    if(map.containsKey("mcn_id")) {
      Object obj = map.get("mcn_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMcnId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mcn_recover_amount")) {
      Object obj = map.get("mcn_recover_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMcnRecoverAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMcnRecoverAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMcnRecoverAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMcnRecoverAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMcnRecoverAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("mcn_recover_time")) {
      Object obj = map.get("mcn_recover_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMcnRecoverTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setMcnRecoverTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMcnRecoverTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMcnRecoverTime(null);
      }
    }
    if(map.containsKey("mcn_recover_status")) {
      Object obj = map.get("mcn_recover_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMcnRecoverStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("ks_id")) {
      Object obj = map.get("ks_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKsId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ks_tenant_code")) {
      Object obj = map.get("ks_tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKsTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAcqBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAcqBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAcqBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAcqBillDate(null);
      }
    }
    if(map.containsKey("order_id")) {
      Object obj = map.get("order_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_no")) {
      Object obj = map.get("refund_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trade_success_time")) {
      Object obj = map.get("trade_success_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTradeSuccessTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTradeSuccessTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTradeSuccessTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTradeSuccessTime(null);
      }
    }
    if(map.containsKey("refund_apply_time")) {
      Object obj = map.get("refund_apply_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRefundApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRefundApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRefundApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRefundApplyTime(null);
      }
    }
    if(map.containsKey("refund_finish_time")) {
      Object obj = map.get("refund_finish_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRefundFinishTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRefundFinishTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRefundFinishTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRefundFinishTime(null);
      }
    }
    if(map.containsKey("gmt_refund_finish_time")) {
      Object obj = map.get("gmt_refund_finish_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtRefundFinishTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtRefundFinishTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtRefundFinishTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtRefundFinishTime(null);
      }
    }
    if(map.containsKey("settlement_time")) {
      Object obj = map.get("settlement_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSettlementTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSettlementTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettlementTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSettlementTime(null);
      }
    }
    if(map.containsKey("short_video_status")) {
      Object obj = map.get("short_video_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShortVideoStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("platform_time")) {
      Object obj = map.get("platform_time");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPlatformTime((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPlatformTime(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPlatformTime(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPlatformTime(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPlatformTime(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("second_activity_user_status")) {
      Object obj = map.get("second_activity_user_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSecondActivityUserStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("platform_amount")) {
      Object obj = map.get("platform_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPlatformAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPlatformAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPlatformAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPlatformAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPlatformAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("actual_pay_amount")) {
      Object obj = map.get("actual_pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setActualPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setActualPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setActualPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActualPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setActualPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("kzk_amount")) {
      Object obj = map.get("kzk_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setKzkAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setKzkAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setKzkAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setKzkAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setKzkAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("distributor_commision")) {
      Object obj = map.get("distributor_commision");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDistributorCommision((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDistributorCommision(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDistributorCommision(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDistributorCommision(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDistributorCommision(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("cutter_amount")) {
      Object obj = map.get("cutter_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCutterAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCutterAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCutterAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCutterAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCutterAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("freight_refund_amount")) {
      Object obj = map.get("freight_refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setFreightRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setFreightRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setFreightRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFreightRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setFreightRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("second_activity_user_complete_time")) {
      Object obj = map.get("second_activity_user_complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSecondActivityUserCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSecondActivityUserCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSecondActivityUserCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSecondActivityUserCompleteTime(null);
      }
    }
    if(map.containsKey("distributor_status")) {
      Object obj = map.get("distributor_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistributorStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("second_activity_user_amount")) {
      Object obj = map.get("second_activity_user_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSecondActivityUserAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSecondActivityUserAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSecondActivityUserAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSecondActivityUserAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSecondActivityUserAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("service_amount")) {
      Object obj = map.get("service_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setServiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setServiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setServiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setServiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setServiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("cutter_status")) {
      Object obj = map.get("cutter_status");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCutterStatus((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCutterStatus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCutterStatus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCutterStatus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCutterStatus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("platform_allowance_refund_amount")) {
      Object obj = map.get("platform_allowance_refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPlatformAllowanceRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPlatformAllowanceRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPlatformAllowanceRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPlatformAllowanceRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPlatformAllowanceRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("activity_user_complete_time")) {
      Object obj = map.get("activity_user_complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setActivityUserCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setActivityUserCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActivityUserCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setActivityUserCompleteTime(null);
      }
    }
    if(map.containsKey("second_activity_user_commision")) {
      Object obj = map.get("second_activity_user_commision");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSecondActivityUserCommision(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSecondActivityUserCommision((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSecondActivityUserCommision(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSecondActivityUserCommision(null);
      }
    }
    if(map.containsKey("activity_user_amount")) {
      Object obj = map.get("activity_user_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setActivityUserAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setActivityUserAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setActivityUserAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActivityUserAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setActivityUserAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("refund_amount")) {
      Object obj = map.get("refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("kzk_status")) {
      Object obj = map.get("kzk_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKzkStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("activity_user_commision")) {
      Object obj = map.get("activity_user_commision");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setActivityUserCommision((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setActivityUserCommision(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setActivityUserCommision(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActivityUserCommision(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setActivityUserCommision(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("platform_allowance_amount")) {
      Object obj = map.get("platform_allowance_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPlatformAllowanceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPlatformAllowanceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPlatformAllowanceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPlatformAllowanceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPlatformAllowanceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("recover")) {
      Object obj = map.get("recover");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setRecover((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRecover(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("distributor_tr_amount")) {
      Object obj = map.get("distributor_tr_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDistributorTrAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDistributorTrAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDistributorTrAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDistributorTrAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDistributorTrAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("no_recover_reason")) {
      Object obj = map.get("no_recover_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNoRecoverReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cutter_complete_time")) {
      Object obj = map.get("cutter_complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCutterCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCutterCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCutterCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCutterCompleteTime(null);
      }
    }
    if(map.containsKey("activity_user_status")) {
      Object obj = map.get("activity_user_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setActivityUserStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("service_complete_time")) {
      Object obj = map.get("service_complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setServiceCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setServiceCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setServiceCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setServiceCompleteTime(null);
      }
    }
    if(map.containsKey("short_video_complete_time")) {
      Object obj = map.get("short_video_complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setShortVideoCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setShortVideoCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setShortVideoCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setShortVideoCompleteTime(null);
      }
    }
    if(map.containsKey("short_video_amount")) {
      Object obj = map.get("short_video_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setShortVideoAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setShortVideoAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setShortVideoAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setShortVideoAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setShortVideoAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("distributor_amount")) {
      Object obj = map.get("distributor_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDistributorAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDistributorAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDistributorAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDistributorAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDistributorAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("seller_platform_commission_amount")) {
      Object obj = map.get("seller_platform_commission_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSellerPlatformCommissionAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSellerPlatformCommissionAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSellerPlatformCommissionAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSellerPlatformCommissionAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerPlatformCommissionAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("anchor_hong_bao_amount")) {
      Object obj = map.get("anchor_hong_bao_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAnchorHongBaoAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAnchorHongBaoAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAnchorHongBaoAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAnchorHongBaoAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAnchorHongBaoAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("service_status")) {
      Object obj = map.get("service_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setServiceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("platform_status")) {
      Object obj = map.get("platform_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlatformStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distributor_complete_time")) {
      Object obj = map.get("distributor_complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDistributorCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDistributorCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDistributorCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDistributorCompleteTime(null);
      }
    }
    if(map.containsKey("kzk_complete_time")) {
      Object obj = map.get("kzk_complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setKzkCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setKzkCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setKzkCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setKzkCompleteTime(null);
      }
    }
    if(map.containsKey("mcn_id")) {
      Object obj = map.get("mcn_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMcnId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mcn_recover_amount")) {
      Object obj = map.get("mcn_recover_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setMcnRecoverAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setMcnRecoverAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setMcnRecoverAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMcnRecoverAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setMcnRecoverAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("mcn_recover_time")) {
      Object obj = map.get("mcn_recover_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMcnRecoverTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setMcnRecoverTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMcnRecoverTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setMcnRecoverTime(null);
      }
    }
    if(map.containsKey("mcn_recover_status")) {
      Object obj = map.get("mcn_recover_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMcnRecoverStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
