package com.xforceplus.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-10-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PddAfterSale implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 拼多多ID
   */
  private String pddId;

  /**
   * 店铺ID
   */
  private String shopId;

  /**
   * 租户编号
   */
  private String pddTenantCode;

  /**
   * 售后原因
   */
  private String afterSaleReason;

  /**
   * 售后状态
   */
  private String afterSalesStatus;

  /**
   * 售后类型
   */
  private Long afterSalesType;

  /**
   * 成团时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime confirmTime;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createdTime;

  /**
   * 是否纠纷
   */
  private Boolean disputeRefundStatus;

  /**
   * 订单金额
   */
  private BigDecimal orderAmount;

  /**
   * 订单编号
   */
  private String orderSn;

  /**
   * 退款金额
   */
  private BigDecimal refundAmount;

  /**
   * 同意退款操作人角色
   */
  private String refundOperatorRole;

  /**
   * 退货物流公司名称
   */
  private String shippingName;

  /**
   * 快递运单号
   */
  private String trackingNumber;

  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updatedTime;

  /**
   * 是否到货
   */
  private String userShippingStatus;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 单据流转处理状态
   */
  private String dealStatus;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("pdd_id", pddId);
      map.put("shop_id", shopId);
      map.put("pdd_tenant_code", pddTenantCode);
      map.put("after_sale_reason", afterSaleReason);
      map.put("after_sales_status", afterSalesStatus);
      map.put("after_sales_type", afterSalesType);
      map.put("confirm_time", BocpGenUtils.toTimestamp(confirmTime));
      map.put("created_time", BocpGenUtils.toTimestamp(createdTime));
      map.put("dispute_refund_status", disputeRefundStatus);
      map.put("order_amount", orderAmount);
      map.put("order_sn", orderSn);
      map.put("refund_amount", refundAmount);
      map.put("refund_operator_role", refundOperatorRole);
      map.put("shipping_name", shippingName);
      map.put("tracking_number", trackingNumber);
      map.put("updated_time", BocpGenUtils.toTimestamp(updatedTime));
      map.put("user_shipping_status", userShippingStatus);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("deal_status", dealStatus);
      map.put("org_tree", orgTree);

      return map;
  }

  public static PddAfterSale fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PddAfterSale entity = new PddAfterSale();
    if(map.containsKey("pdd_id")) {
      Object obj = map.get("pdd_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPddId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdd_tenant_code")) {
      Object obj = map.get("pdd_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPddTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("after_sale_reason")) {
      Object obj = map.get("after_sale_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAfterSaleReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("after_sales_status")) {
      Object obj = map.get("after_sales_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAfterSalesStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("after_sales_type")) {
      Object obj = map.get("after_sales_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAfterSalesType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAfterSalesType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAfterSalesType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("confirm_time")) {
      Object obj = map.get("confirm_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setConfirmTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setConfirmTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setConfirmTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setConfirmTime(null);
      }
    }
    if(map.containsKey("created_time")) {
      Object obj = map.get("created_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreatedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreatedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreatedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreatedTime(null);
      }
    }
    if(map.containsKey("dispute_refund_status")) {
      Object obj = map.get("dispute_refund_status");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setDisputeRefundStatus((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDisputeRefundStatus(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("order_amount")) {
      Object obj = map.get("order_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("order_sn")) {
      Object obj = map.get("order_sn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderSn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_amount")) {
      Object obj = map.get("refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("refund_operator_role")) {
      Object obj = map.get("refund_operator_role");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundOperatorRole((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipping_name")) {
      Object obj = map.get("shipping_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShippingName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tracking_number")) {
      Object obj = map.get("tracking_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTrackingNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("updated_time")) {
      Object obj = map.get("updated_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdatedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdatedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdatedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdatedTime(null);
      }
    }
    if(map.containsKey("user_shipping_status")) {
      Object obj = map.get("user_shipping_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserShippingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("pdd_id")) {
      Object obj = map.get("pdd_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPddId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pdd_tenant_code")) {
      Object obj = map.get("pdd_tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPddTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("after_sale_reason")) {
      Object obj = map.get("after_sale_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAfterSaleReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("after_sales_status")) {
      Object obj = map.get("after_sales_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAfterSalesStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("after_sales_type")) {
      Object obj = map.get("after_sales_type");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAfterSalesType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAfterSalesType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAfterSalesType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("confirm_time")) {
      Object obj = map.get("confirm_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setConfirmTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setConfirmTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setConfirmTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setConfirmTime(null);
      }
    }
    if(map.containsKey("created_time")) {
      Object obj = map.get("created_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreatedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreatedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreatedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreatedTime(null);
      }
    }
    if(map.containsKey("dispute_refund_status")) {
      Object obj = map.get("dispute_refund_status");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setDisputeRefundStatus((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDisputeRefundStatus(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("order_amount")) {
      Object obj = map.get("order_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrderAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrderAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrderAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("order_sn")) {
      Object obj = map.get("order_sn");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderSn((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_amount")) {
      Object obj = map.get("refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("refund_operator_role")) {
      Object obj = map.get("refund_operator_role");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundOperatorRole((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipping_name")) {
      Object obj = map.get("shipping_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShippingName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tracking_number")) {
      Object obj = map.get("tracking_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTrackingNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("updated_time")) {
      Object obj = map.get("updated_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdatedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdatedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdatedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdatedTime(null);
      }
    }
    if(map.containsKey("user_shipping_status")) {
      Object obj = map.get("user_shipping_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUserShippingStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
