package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_check_account_bill_desc_tag
 * </p>
 *
 * @author ultraman
 * @since 2024-11-03
 */
public enum DyCheckAccountBillDescTag {

    _0("0", "其他"),
    _1("1", "达人带货佣金"),
    _2("2", "达人佣金退款"),
    _3("3", "订单结算"),
    _4("4", "部分结算"),
    _5("5", "运费单结算"),
    _6("6", "服务费返还"),
    _7("7", "平台补贴扣回"),
    _8("8", "退款失败退票"),
    _9("9", "结算重复扣款调账"),
    _10("10", "保证金退款"),
    _11("11", "提现"),
    _12("12", "提现退票"),
    _13("13", "极速退款分账"),
    _14("14", "小额打款(原因:补差价)"),
    _15("15", "小额打款(原因:其他)"),
    _16("16", "小额打款(原因:商品补偿)"),
    _17("17", "小额打款(原因:运费补偿)"),
    _18("18", "小额打款退票"),
    _19("19", "已退款"),
    _20("20", "运费险扣减货款"),
    _21("21", "支付BIC服务费"),
    _22("22", "BIC服务费退票"),
    _23("23", "原路退");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DyCheckAccountBillDescTag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyCheckAccountBillDescTag fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "12":
                return _12;
            case "13":
                return _13;
            case "14":
                return _14;
            case "15":
                return _15;
            case "16":
                return _16;
            case "17":
                return _17;
            case "18":
                return _18;
            case "19":
                return _19;
            case "20":
                return _20;
            case "21":
                return _21;
            case "22":
                return _22;
            case "23":
                return _23;
            default:
                return null;
        }
    }
}
