package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ks_settlement_status
 * </p>
 *
 * @author ultraman
 * @since 2024-11-03
 */
public enum KsSettlementStatus {

    INIT("INIT", "初始化"),
    WAITING("WAITING", "待结算"),
    COMPLETED("COMPLETED", "已结算"),
    CLOSE("CLOSE", "已关闭");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    KsSettlementStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KsSettlementStatus fromCode(String code){
        switch(code) {
            case "INIT":
                return INIT;
            case "WAITING":
                return WAITING;
            case "COMPLETED":
                return COMPLETED;
            case "CLOSE":
                return CLOSE;
            default:
                return null;
        }
    }
}
