package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pdd_shipping_type
 * </p>
 *
 * @author ultraman
 * @since 2024-11-03
 */
public enum PddShippingType {

    _1("1", "预约配送"),
    _2("2", "1小时达"),
    _3("3", "消费者预约送达"),
    _0("0", " ");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PddShippingType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PddShippingType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
