package com.xforceplus.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class JkyOmsOrder implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 吉客云id
   */
  private Long jkyId;

  /**
   * 对账金额
   */
  private BigDecimal checkTotal;

  /**
   * 订单编号
   */
  private String tradeNo;

  /**
   * 其它费用
   */
  private BigDecimal otherFee;

  /**
   * 结算币种
   */
  private String chargeCurrency;

  /**
   * 收款账户
   */
  private String accountName;

  /**
   * 支付方式
   */
  private String payType;

  /**
   * 支付单号
   */
  private String payNo;

  /**
   * 客服备注
   */
  private String sellerMemo;

  /**
   * 买家备注
   */
  private String buyerMemo;

  /**
   * 追加备注
   */
  private String appendMemo;

  /**
   * 订单来源
   */
  private String tradeFrom;

  /**
   * 登记人
   */
  private String register;

  /**
   * 业务员
   */
  private String seller;

  /**
   * 审核人
   */
  private String auditor;

  /**
   * 复核人
   */
  private String reviewer;

  /**
   * 预估重量
   */
  private BigDecimal estimateWeight;

  /**
   * 包裹重量
   */
  private BigDecimal packageWeight;

  /**
   * 订单总数量
   */
  private BigDecimal tradeCount;

  /**
   * 商品样数
   */
  private BigDecimal goodsTypeCount;

  /**
   * 冻结原因
   */
  private String freezeReason;

  /**
   * 问题单具体描述
   */
  private String abnormalDescription;

  /**
   * 网店订单号
   */
  private String onlineTradeNo;

  /**
   * 货品摘要
   */
  private String goodslist;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;

  /**
   * 最后修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtModified;

  /**
   * 出库单号
   */
  private String stockoutNo;

  /**
   * 确认时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime confirmTime;

  /**
   * 部门名称
   */
  private String departName;

  /**
   * 承诺发货时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lastShipTime;

  /**
   * 付款状态
   */
  private String payStatus;

  /**
   * 结算币种编码
   */
  private String chargeCurrencyCode;

  /**
   * 结算汇率
   */
  private BigDecimal chargeExchangeRate;

  /**
   * 销售单状态
   */
  private String tradeStatus;

  /**
   * 毛利
   */
  private BigDecimal grossProfit;

  /**
   * 订单预估体积
   */
  private BigDecimal estimateVolume;

  /**
   * 客户类型
   */
  private String customerTypeName;

  /**
   * 客户等级
   */
  private String customerGradeName;

  /**
   * 客户标签
   */
  private String customerTags;

  /**
   * 客户编号
   */
  private String customerCode;

  /**
   * 折扣
   */
  private BigDecimal customerDiscount;

  /**
   * 特别提醒
   */
  private String specialReminding;

  /**
   * 黑名单
   */
  private Long blackList;

  /**
   * 下单时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime tradeTime;

  /**
   * 国家
   */
  private String country;

  /**
   * 省
   */
  private String state;

  /**
   * 城市
   */
  private String citi;

  /**
   * 区县
   */
  private String district;

  /**
   * 街道
   */
  private String town;

  /**
   * 邮编
   */
  private String zip;

  /**
   * 支付时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime payTime;

  /**
   * 国家编码
   */
  private String countryCode;

  /**
   * 城市编码
   */
  private String cityCode;

  /**
   * 发票类型
   */
  private String invoiceType;

  /**
   * 购方名称
   */
  private String payerName;

  /**
   * 购方税号
   */
  private String payerRegno;

  /**
   * 购方开户行及帐号
   */
  private String payerBankAccount;

  /**
   * 购方电话
   */
  private String payerPhone;

  /**
   * 审核时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime auditTime;

  /**
   * 购方地址
   */
  private String payerAddress;

  /**
   * 发票号码
   */
  private String invoiceNo;

  /**
   * 发票代码
   */
  private String invoiceCode;

  /**
   * 发票开具状态
   */
  private Long invoiceStatus;

  /**
   * 购方开户行
   */
  private String payerBankName;

  /**
   * 预定类别描述
   */
  private String preTypedetail;

  /**
   * 付首款金额
   */
  private BigDecimal firstPayment;

  /**
   * 付尾款金额
   */
  private BigDecimal finalPayment;

  /**
   * 付首款时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime firstPaytime;

  /**
   * 付尾款时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime finalPaytime;

  /**
   * 复核时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime reviewTime;

  /**
   * 激活时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime activationTime;

  /**
   * 终端货款合计
   */
  private BigDecimal customerTotalFee;

  /**
   * 终端优惠
   */
  private BigDecimal customerDiscountFee;

  /**
   * 通知仓库发货时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime notifyPickTime;

  /**
   * 发货时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime consignTime;

  /**
   * 发货单单号
   */
  private String orderNo;

  /**
   * 终端应收邮资
   */
  private BigDecimal customerPostFee;

  /**
   * 店铺名称
   */
  private String shopName;

  /**
   * 终端应收合计
   */
  private BigDecimal customerPayment;

  /**
   * 公司名称
   */
  private String companyName;

  /**
   * 自定义字段1
   */
  private String customizeTradeColumn1;

  /**
   * 自定义字段2
   */
  private String customizeTradeColumn2;

  /**
   * 自定义字段3
   */
  private String customizeTradeColumn3;

  /**
   * 自定义字段4
   */
  private String customizeTradeColumn4;

  /**
   * 自定义字段5
   */
  private String customizeTradeColumn5;

  /**
   * 自定义字段6
   */
  private String customizeTradeColumn6;

  /**
   * 自定义字段7
   */
  private String customizeTradeColumn7;

  /**
   * 自定义字段8
   */
  private String customizeTradeColumn8;

  /**
   * 自定义字段9
   */
  private String customizeTradeColumn9;

  /**
   * 自定义字段10
   */
  private String customizeTradeColumn10;

  /**
   * 对账状态
   */
  private String isBillCheck;

  /**
   * 仓库编码
   */
  private String warehouseCode;

  /**
   * 仓库名称
   */
  private String warehouseName;

  /**
   * 物流名称
   */
  private String logisticName;

  /**
   * 系统编码
   */
  private Long tradeId;

  /**
   * 对账时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billDate;

  /**
   * 配送方式
   */
  private String logisticType;

  /**
   * 物流单号
   */
  private String mainPostid;

  /**
   * 订单类型
   */
  private Long tradeType;

  /**
   * 商品金额
   */
  private BigDecimal totalFee;

  /**
   * 税额
   */
  private BigDecimal taxFee;

  /**
   * 应收邮资
   */
  private BigDecimal receivedPostFee;

  /**
   * 优惠金额
   */
  private BigDecimal discountFee;

  /**
   * 应收金额
   */
  private BigDecimal payment;

  /**
   * 平台优惠
   */
  private BigDecimal couponFee;

  /**
   * 已收金额
   */
  private BigDecimal receivedTotal;

  /**
   * 预估邮资
   */
  private BigDecimal postFee;

  /**
   * 是否分表查询
   */
  private Long isTableSwitch;

  /**
   * 完成时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime completeTime;

  /**
   * 店铺编码
   */
  private String shopcode;

  /**
   * 签收时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime signingTime;

  /**
   * 审核时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settleAuditTime;

  /**
   * 是否删除
   */
  private Boolean isDelete;

  /**
   * 应收合计（本币）
   */
  private BigDecimal localPayment;

  /**
   * 汇率
   */
  private BigDecimal localExchangeRate;

  /**
   * 客户账号
   */
  private String customerAccount;

  /**
   * 公司本币
   */
  private String localCurrencyCode;

  /**
   * 平台完成时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime platCompleteTime;

  /**
   * 平台买家唯一标识
   */
  private String buyerOpenUid;

  /**
   * son串
   */
  private String qq;

  /**
   * 销售单退款时间
   */
  private String tradeOrderRefundTime;

  /**
   * 组合装母件数据
   */
  private String assemblyGoodsDetail;

  /**
   * 平台类型
   */
  private Long apiType;

  /**
   * 物流公司编码
   */
  private String logisticCode;

  /**
   * 分销商销售渠道
   */
  private String agentShopName;

  /**
   * 订单状态
   */
  private String tradeStatusExplain;

  /**
   * 标价id
   */
  private String flagIds;

  /**
   * 标记名称
   */
  private String flagNames;

  /**
   * 系统标记id
   */
  private String sysFlagIds;

  /**
   * 平台类型
   */
  private String shopTypeCode;

  /**
   * 售后来源单号
   */
  private String sourceAfterNo;

  /**
   * 卡券code列表
   */
  private String ticketCodeList;

  /**
   * 抖音订单标记
   */
  private String allCompassSourceContentType;

  /**
   * 客户名称
   */
  private String customerName;

  /**
   * 可开票金额
   */
  private BigDecimal invoiceAmount;

  /**
   * 实付金额
   */
  private BigDecimal realFee;

  /**
   * 收款日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime finReceiptTime;

  /**
   * 额外物流单号
   */
  private String extraLogisticNo;

  /**
   * 游标id
   */
  private String scrollId;

  /**
   * 入库创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime myGmtCreate;

  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime myGmtModified;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 对账状态
   */
  @TableField("checkStatus")
  private String checkStatus;

  /**
   * 店铺编号
   */
  private String shopId;

  /**
   * 异常信息
   */
  private String errorMsg;

  /**
   * 业务ID
   */
  private String businessId;

  /**
   * 数据MD5
   */
  @TableField("dataMD5")
  private String dataMD5;

  /**
   * 数据流转状态
   */
  private String dealStatus;

  /**
   * 最新版本
   */
  private Boolean latest;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("jky_id", jkyId);
      map.put("check_total", checkTotal);
      map.put("trade_no", tradeNo);
      map.put("other_fee", otherFee);
      map.put("charge_currency", chargeCurrency);
      map.put("account_name", accountName);
      map.put("pay_type", payType);
      map.put("pay_no", payNo);
      map.put("seller_memo", sellerMemo);
      map.put("buyer_memo", buyerMemo);
      map.put("append_memo", appendMemo);
      map.put("trade_from", tradeFrom);
      map.put("register", register);
      map.put("seller", seller);
      map.put("auditor", auditor);
      map.put("reviewer", reviewer);
      map.put("estimate_weight", estimateWeight);
      map.put("package_weight", packageWeight);
      map.put("trade_count", tradeCount);
      map.put("goods_type_count", goodsTypeCount);
      map.put("freeze_reason", freezeReason);
      map.put("abnormal_description", abnormalDescription);
      map.put("online_trade_no", onlineTradeNo);
      map.put("goodslist", goodslist);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("gmt_modified", BocpGenUtils.toTimestamp(gmtModified));
      map.put("stockout_no", stockoutNo);
      map.put("confirm_time", BocpGenUtils.toTimestamp(confirmTime));
      map.put("depart_name", departName);
      map.put("last_ship_time", BocpGenUtils.toTimestamp(lastShipTime));
      map.put("pay_status", payStatus);
      map.put("charge_currency_code", chargeCurrencyCode);
      map.put("charge_exchange_rate", chargeExchangeRate);
      map.put("trade_status", tradeStatus);
      map.put("gross_profit", grossProfit);
      map.put("estimate_volume", estimateVolume);
      map.put("customer_type_name", customerTypeName);
      map.put("customer_grade_name", customerGradeName);
      map.put("customer_tags", customerTags);
      map.put("customer_code", customerCode);
      map.put("customer_discount", customerDiscount);
      map.put("special_reminding", specialReminding);
      map.put("black_list", blackList);
      map.put("trade_time", BocpGenUtils.toTimestamp(tradeTime));
      map.put("country", country);
      map.put("state", state);
      map.put("citi", citi);
      map.put("district", district);
      map.put("town", town);
      map.put("zip", zip);
      map.put("pay_time", BocpGenUtils.toTimestamp(payTime));
      map.put("country_code", countryCode);
      map.put("city_code", cityCode);
      map.put("invoice_type", invoiceType);
      map.put("payer_name", payerName);
      map.put("payer_regno", payerRegno);
      map.put("payer_bank_account", payerBankAccount);
      map.put("payer_phone", payerPhone);
      map.put("audit_time", BocpGenUtils.toTimestamp(auditTime));
      map.put("payer_address", payerAddress);
      map.put("invoice_no", invoiceNo);
      map.put("invoice_code", invoiceCode);
      map.put("invoice_status", invoiceStatus);
      map.put("payer_bank_name", payerBankName);
      map.put("pre_typedetail", preTypedetail);
      map.put("first_payment", firstPayment);
      map.put("final_payment", finalPayment);
      map.put("first_paytime", BocpGenUtils.toTimestamp(firstPaytime));
      map.put("final_paytime", BocpGenUtils.toTimestamp(finalPaytime));
      map.put("review_time", BocpGenUtils.toTimestamp(reviewTime));
      map.put("activation_time", BocpGenUtils.toTimestamp(activationTime));
      map.put("customer_total_fee", customerTotalFee);
      map.put("customer_discount_fee", customerDiscountFee);
      map.put("notify_pick_time", BocpGenUtils.toTimestamp(notifyPickTime));
      map.put("consign_time", BocpGenUtils.toTimestamp(consignTime));
      map.put("order_no", orderNo);
      map.put("customer_post_fee", customerPostFee);
      map.put("shop_name", shopName);
      map.put("customer_payment", customerPayment);
      map.put("company_name", companyName);
      map.put("customize_trade_column1", customizeTradeColumn1);
      map.put("customize_trade_column2", customizeTradeColumn2);
      map.put("customize_trade_column3", customizeTradeColumn3);
      map.put("customize_trade_column4", customizeTradeColumn4);
      map.put("customize_trade_column5", customizeTradeColumn5);
      map.put("customize_trade_column6", customizeTradeColumn6);
      map.put("customize_trade_column7", customizeTradeColumn7);
      map.put("customize_trade_column8", customizeTradeColumn8);
      map.put("customize_trade_column9", customizeTradeColumn9);
      map.put("customize_trade_column10", customizeTradeColumn10);
      map.put("is_bill_check", isBillCheck);
      map.put("warehouse_code", warehouseCode);
      map.put("warehouse_name", warehouseName);
      map.put("logistic_name", logisticName);
      map.put("trade_id", tradeId);
      map.put("bill_date", BocpGenUtils.toTimestamp(billDate));
      map.put("logistic_type", logisticType);
      map.put("main_postid", mainPostid);
      map.put("trade_type", tradeType);
      map.put("total_fee", totalFee);
      map.put("tax_fee", taxFee);
      map.put("received_post_fee", receivedPostFee);
      map.put("discount_fee", discountFee);
      map.put("payment", payment);
      map.put("coupon_fee", couponFee);
      map.put("received_total", receivedTotal);
      map.put("post_fee", postFee);
      map.put("is_table_switch", isTableSwitch);
      map.put("complete_time", BocpGenUtils.toTimestamp(completeTime));
      map.put("shopcode", shopcode);
      map.put("signing_time", BocpGenUtils.toTimestamp(signingTime));
      map.put("settle_audit_time", BocpGenUtils.toTimestamp(settleAuditTime));
      map.put("is_delete", isDelete);
      map.put("local_payment", localPayment);
      map.put("local_exchange_rate", localExchangeRate);
      map.put("customer_account", customerAccount);
      map.put("local_currency_code", localCurrencyCode);
      map.put("plat_complete_time", BocpGenUtils.toTimestamp(platCompleteTime));
      map.put("buyer_open_uid", buyerOpenUid);
      map.put("qq", qq);
      map.put("trade_order_refund_time", tradeOrderRefundTime);
      map.put("assembly_goods_detail", assemblyGoodsDetail);
      map.put("api_type", apiType);
      map.put("logistic_code", logisticCode);
      map.put("agent_shop_name", agentShopName);
      map.put("trade_status_explain", tradeStatusExplain);
      map.put("flag_ids", flagIds);
      map.put("flag_names", flagNames);
      map.put("sys_flag_ids", sysFlagIds);
      map.put("shop_type_code", shopTypeCode);
      map.put("source_after_no", sourceAfterNo);
      map.put("ticket_code_list", ticketCodeList);
      map.put("all_compass_source_content_type", allCompassSourceContentType);
      map.put("customer_name", customerName);
      map.put("invoice_amount", invoiceAmount);
      map.put("real_fee", realFee);
      map.put("fin_receipt_time", BocpGenUtils.toTimestamp(finReceiptTime));
      map.put("extra_logistic_no", extraLogisticNo);
      map.put("scroll_id", scrollId);
      map.put("my_gmt_create", BocpGenUtils.toTimestamp(myGmtCreate));
      map.put("my_gmt_modified", BocpGenUtils.toTimestamp(myGmtModified));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("checkStatus", checkStatus);
      map.put("shop_id", shopId);
      map.put("error_msg", errorMsg);
      map.put("business_id", businessId);
      map.put("dataMD5", dataMD5);
      map.put("deal_status", dealStatus);
      map.put("latest", latest);
      map.put("versionNo", versionNo);
      map.put("org_tree", orgTree);

      return map;
  }

  public static JkyOmsOrder fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    JkyOmsOrder entity = new JkyOmsOrder();
    if(map.containsKey("jky_id")) {
      Object obj = map.get("jky_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setJkyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJkyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJkyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_total")) {
      Object obj = map.get("check_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCheckTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCheckTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCheckTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("trade_no")) {
      Object obj = map.get("trade_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("other_fee")) {
      Object obj = map.get("other_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOtherFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOtherFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOtherFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOtherFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOtherFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("charge_currency")) {
      Object obj = map.get("charge_currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_name")) {
      Object obj = map.get("account_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_no")) {
      Object obj = map.get("pay_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_memo")) {
      Object obj = map.get("seller_memo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerMemo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_memo")) {
      Object obj = map.get("buyer_memo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerMemo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("append_memo")) {
      Object obj = map.get("append_memo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppendMemo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_from")) {
      Object obj = map.get("trade_from");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("register")) {
      Object obj = map.get("register");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegister((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller")) {
      Object obj = map.get("seller");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSeller((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("auditor")) {
      Object obj = map.get("auditor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reviewer")) {
      Object obj = map.get("reviewer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReviewer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("estimate_weight")) {
      Object obj = map.get("estimate_weight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setEstimateWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setEstimateWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setEstimateWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEstimateWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEstimateWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("package_weight")) {
      Object obj = map.get("package_weight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("trade_count")) {
      Object obj = map.get("trade_count");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTradeCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTradeCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTradeCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTradeCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTradeCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goods_type_count")) {
      Object obj = map.get("goods_type_count");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGoodsTypeCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGoodsTypeCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGoodsTypeCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodsTypeCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodsTypeCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("freeze_reason")) {
      Object obj = map.get("freeze_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFreezeReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("abnormal_description")) {
      Object obj = map.get("abnormal_description");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAbnormalDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("online_trade_no")) {
      Object obj = map.get("online_trade_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOnlineTradeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodslist")) {
      Object obj = map.get("goodslist");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodslist((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtModified(null);
      }
    }
    if(map.containsKey("stockout_no")) {
      Object obj = map.get("stockout_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStockoutNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("confirm_time")) {
      Object obj = map.get("confirm_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setConfirmTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setConfirmTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setConfirmTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setConfirmTime(null);
      }
    }
    if(map.containsKey("depart_name")) {
      Object obj = map.get("depart_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDepartName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("last_ship_time")) {
      Object obj = map.get("last_ship_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLastShipTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setLastShipTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLastShipTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLastShipTime(null);
      }
    }
    if(map.containsKey("pay_status")) {
      Object obj = map.get("pay_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_currency_code")) {
      Object obj = map.get("charge_currency_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChargeCurrencyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("charge_exchange_rate")) {
      Object obj = map.get("charge_exchange_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setChargeExchangeRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setChargeExchangeRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setChargeExchangeRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setChargeExchangeRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setChargeExchangeRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("trade_status")) {
      Object obj = map.get("trade_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gross_profit")) {
      Object obj = map.get("gross_profit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGrossProfit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGrossProfit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGrossProfit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGrossProfit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGrossProfit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("estimate_volume")) {
      Object obj = map.get("estimate_volume");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setEstimateVolume((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setEstimateVolume(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setEstimateVolume(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEstimateVolume(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEstimateVolume(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customer_type_name")) {
      Object obj = map.get("customer_type_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_grade_name")) {
      Object obj = map.get("customer_grade_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerGradeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_tags")) {
      Object obj = map.get("customer_tags");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerTags((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_code")) {
      Object obj = map.get("customer_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_discount")) {
      Object obj = map.get("customer_discount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCustomerDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCustomerDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCustomerDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCustomerDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCustomerDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("special_reminding")) {
      Object obj = map.get("special_reminding");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecialReminding((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("black_list")) {
      Object obj = map.get("black_list");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBlackList((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBlackList(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBlackList(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("trade_time")) {
      Object obj = map.get("trade_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTradeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTradeTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTradeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTradeTime(null);
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("state")) {
      Object obj = map.get("state");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setState((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("citi")) {
      Object obj = map.get("citi");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCiti((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("district")) {
      Object obj = map.get("district");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistrict((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("town")) {
      Object obj = map.get("town");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTown((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zip")) {
      Object obj = map.get("zip");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZip((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_time")) {
      Object obj = map.get("pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPayTime(null);
      }
    }
    if(map.containsKey("country_code")) {
      Object obj = map.get("country_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCountryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("city_code")) {
      Object obj = map.get("city_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCityCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer_name")) {
      Object obj = map.get("payer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer_regno")) {
      Object obj = map.get("payer_regno");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayerRegno((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer_bank_account")) {
      Object obj = map.get("payer_bank_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer_phone")) {
      Object obj = map.get("payer_phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayerPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_time")) {
      Object obj = map.get("audit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuditTime(null);
      }
    }
    if(map.containsKey("payer_address")) {
      Object obj = map.get("payer_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("payer_bank_name")) {
      Object obj = map.get("payer_bank_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pre_typedetail")) {
      Object obj = map.get("pre_typedetail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPreTypedetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("first_payment")) {
      Object obj = map.get("first_payment");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFirstPayment((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFirstPayment(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFirstPayment(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFirstPayment(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFirstPayment(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("final_payment")) {
      Object obj = map.get("final_payment");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFinalPayment((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFinalPayment(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFinalPayment(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFinalPayment(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFinalPayment(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("first_paytime")) {
      Object obj = map.get("first_paytime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFirstPaytime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setFirstPaytime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFirstPaytime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setFirstPaytime(null);
      }
    }
    if(map.containsKey("final_paytime")) {
      Object obj = map.get("final_paytime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFinalPaytime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setFinalPaytime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFinalPaytime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setFinalPaytime(null);
      }
    }
    if(map.containsKey("review_time")) {
      Object obj = map.get("review_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReviewTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReviewTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReviewTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReviewTime(null);
      }
    }
    if(map.containsKey("activation_time")) {
      Object obj = map.get("activation_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setActivationTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setActivationTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActivationTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setActivationTime(null);
      }
    }
    if(map.containsKey("customer_total_fee")) {
      Object obj = map.get("customer_total_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCustomerTotalFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCustomerTotalFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCustomerTotalFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCustomerTotalFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCustomerTotalFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customer_discount_fee")) {
      Object obj = map.get("customer_discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCustomerDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCustomerDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCustomerDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCustomerDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCustomerDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("notify_pick_time")) {
      Object obj = map.get("notify_pick_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setNotifyPickTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setNotifyPickTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNotifyPickTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setNotifyPickTime(null);
      }
    }
    if(map.containsKey("consign_time")) {
      Object obj = map.get("consign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setConsignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setConsignTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setConsignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setConsignTime(null);
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_post_fee")) {
      Object obj = map.get("customer_post_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCustomerPostFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCustomerPostFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCustomerPostFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCustomerPostFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCustomerPostFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_payment")) {
      Object obj = map.get("customer_payment");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCustomerPayment((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCustomerPayment(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCustomerPayment(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCustomerPayment(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCustomerPayment(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customize_trade_column1")) {
      Object obj = map.get("customize_trade_column1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomizeTradeColumn1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customize_trade_column2")) {
      Object obj = map.get("customize_trade_column2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomizeTradeColumn2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customize_trade_column3")) {
      Object obj = map.get("customize_trade_column3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomizeTradeColumn3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customize_trade_column4")) {
      Object obj = map.get("customize_trade_column4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomizeTradeColumn4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customize_trade_column5")) {
      Object obj = map.get("customize_trade_column5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomizeTradeColumn5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customize_trade_column6")) {
      Object obj = map.get("customize_trade_column6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomizeTradeColumn6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customize_trade_column7")) {
      Object obj = map.get("customize_trade_column7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomizeTradeColumn7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customize_trade_column8")) {
      Object obj = map.get("customize_trade_column8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomizeTradeColumn8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customize_trade_column9")) {
      Object obj = map.get("customize_trade_column9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomizeTradeColumn9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customize_trade_column10")) {
      Object obj = map.get("customize_trade_column10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomizeTradeColumn10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_bill_check")) {
      Object obj = map.get("is_bill_check");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsBillCheck((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouse_code")) {
      Object obj = map.get("warehouse_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouse_name")) {
      Object obj = map.get("warehouse_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistic_name")) {
      Object obj = map.get("logistic_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_id")) {
      Object obj = map.get("trade_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTradeId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTradeId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTradeId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bill_date")) {
      Object obj = map.get("bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillDate(null);
      }
    }
    if(map.containsKey("logistic_type")) {
      Object obj = map.get("logistic_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("main_postid")) {
      Object obj = map.get("main_postid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMainPostid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_type")) {
      Object obj = map.get("trade_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTradeType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTradeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTradeType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("total_fee")) {
      Object obj = map.get("total_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTotalFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_fee")) {
      Object obj = map.get("tax_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("received_post_fee")) {
      Object obj = map.get("received_post_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivedPostFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivedPostFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivedPostFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivedPostFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivedPostFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discount_fee")) {
      Object obj = map.get("discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payment")) {
      Object obj = map.get("payment");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayment((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayment(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayment(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayment(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayment(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("coupon_fee")) {
      Object obj = map.get("coupon_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCouponFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCouponFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCouponFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCouponFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCouponFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("received_total")) {
      Object obj = map.get("received_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceivedTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceivedTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceivedTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setReceivedTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceivedTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("post_fee")) {
      Object obj = map.get("post_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPostFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPostFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPostFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPostFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("is_table_switch")) {
      Object obj = map.get("is_table_switch");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setIsTableSwitch((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsTableSwitch(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setIsTableSwitch(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("complete_time")) {
      Object obj = map.get("complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCompleteTime(null);
      }
    }
    if(map.containsKey("shopcode")) {
      Object obj = map.get("shopcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("signing_time")) {
      Object obj = map.get("signing_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSigningTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSigningTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSigningTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSigningTime(null);
      }
    }
    if(map.containsKey("settle_audit_time")) {
      Object obj = map.get("settle_audit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettleAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSettleAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSettleAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettleAuditTime(null);
      }
    }
    if(map.containsKey("is_delete")) {
      Object obj = map.get("is_delete");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsDelete((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsDelete(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("local_payment")) {
      Object obj = map.get("local_payment");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLocalPayment((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLocalPayment(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLocalPayment(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLocalPayment(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLocalPayment(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("local_exchange_rate")) {
      Object obj = map.get("local_exchange_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setLocalExchangeRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setLocalExchangeRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setLocalExchangeRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLocalExchangeRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLocalExchangeRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("customer_account")) {
      Object obj = map.get("customer_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("local_currency_code")) {
      Object obj = map.get("local_currency_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLocalCurrencyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plat_complete_time")) {
      Object obj = map.get("plat_complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPlatCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPlatCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPlatCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPlatCompleteTime(null);
      }
    }
    if(map.containsKey("buyer_open_uid")) {
      Object obj = map.get("buyer_open_uid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerOpenUid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qq")) {
      Object obj = map.get("qq");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQq((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_order_refund_time")) {
      Object obj = map.get("trade_order_refund_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeOrderRefundTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("assembly_goods_detail")) {
      Object obj = map.get("assembly_goods_detail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAssemblyGoodsDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("api_type")) {
      Object obj = map.get("api_type");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApiType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setApiType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setApiType(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("logistic_code")) {
      Object obj = map.get("logistic_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("agent_shop_name")) {
      Object obj = map.get("agent_shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAgentShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_status_explain")) {
      Object obj = map.get("trade_status_explain");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeStatusExplain((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flag_ids")) {
      Object obj = map.get("flag_ids");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlagIds((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flag_names")) {
      Object obj = map.get("flag_names");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlagNames((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sys_flag_ids")) {
      Object obj = map.get("sys_flag_ids");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSysFlagIds((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_type_code")) {
      Object obj = map.get("shop_type_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("source_after_no")) {
      Object obj = map.get("source_after_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceAfterNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_code_list")) {
      Object obj = map.get("ticket_code_list");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTicketCodeList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("all_compass_source_content_type")) {
      Object obj = map.get("all_compass_source_content_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAllCompassSourceContentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_name")) {
      Object obj = map.get("customer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_amount")) {
      Object obj = map.get("invoice_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("real_fee")) {
      Object obj = map.get("real_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRealFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRealFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRealFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRealFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRealFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("fin_receipt_time")) {
      Object obj = map.get("fin_receipt_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFinReceiptTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setFinReceiptTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFinReceiptTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setFinReceiptTime(null);
      }
    }
    if(map.containsKey("extra_logistic_no")) {
      Object obj = map.get("extra_logistic_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtraLogisticNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scroll_id")) {
      Object obj = map.get("scroll_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setScrollId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("my_gmt_create")) {
      Object obj = map.get("my_gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMyGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setMyGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMyGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMyGmtCreate(null);
      }
    }
    if(map.containsKey("my_gmt_modified")) {
      Object obj = map.get("my_gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMyGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setMyGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMyGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMyGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("jky_id")) {
      Object obj = map.get("jky_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setJkyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJkyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setJkyId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("check_total")) {
      Object obj = map.get("check_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCheckTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCheckTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCheckTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCheckTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCheckTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("trade_no")) {
      Object obj = map.get("trade_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("other_fee")) {
      Object obj = map.get("other_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOtherFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOtherFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOtherFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOtherFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOtherFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("charge_currency")) {
      Object obj = map.get("charge_currency");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeCurrency((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_name")) {
      Object obj = map.get("account_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_no")) {
      Object obj = map.get("pay_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_memo")) {
      Object obj = map.get("seller_memo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerMemo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_memo")) {
      Object obj = map.get("buyer_memo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerMemo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("append_memo")) {
      Object obj = map.get("append_memo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAppendMemo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trade_from")) {
      Object obj = map.get("trade_from");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeFrom((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("register")) {
      Object obj = map.get("register");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegister((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller")) {
      Object obj = map.get("seller");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSeller((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("auditor")) {
      Object obj = map.get("auditor");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditor((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reviewer")) {
      Object obj = map.get("reviewer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReviewer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("estimate_weight")) {
      Object obj = map.get("estimate_weight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setEstimateWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setEstimateWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setEstimateWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setEstimateWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setEstimateWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("package_weight")) {
      Object obj = map.get("package_weight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPackageWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPackageWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPackageWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPackageWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPackageWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("trade_count")) {
      Object obj = map.get("trade_count");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTradeCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTradeCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTradeCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTradeCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTradeCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("goods_type_count")) {
      Object obj = map.get("goods_type_count");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setGoodsTypeCount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setGoodsTypeCount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setGoodsTypeCount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGoodsTypeCount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setGoodsTypeCount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("freeze_reason")) {
      Object obj = map.get("freeze_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFreezeReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("abnormal_description")) {
      Object obj = map.get("abnormal_description");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAbnormalDescription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("online_trade_no")) {
      Object obj = map.get("online_trade_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOnlineTradeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goodslist")) {
      Object obj = map.get("goodslist");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodslist((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("gmt_modified")) {
      Object obj = map.get("gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtModified(null);
      }
    }
    if(map.containsKey("stockout_no")) {
      Object obj = map.get("stockout_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStockoutNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("confirm_time")) {
      Object obj = map.get("confirm_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setConfirmTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setConfirmTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setConfirmTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setConfirmTime(null);
      }
    }
    if(map.containsKey("depart_name")) {
      Object obj = map.get("depart_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDepartName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("last_ship_time")) {
      Object obj = map.get("last_ship_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLastShipTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setLastShipTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLastShipTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setLastShipTime(null);
      }
    }
    if(map.containsKey("pay_status")) {
      Object obj = map.get("pay_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_currency_code")) {
      Object obj = map.get("charge_currency_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChargeCurrencyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("charge_exchange_rate")) {
      Object obj = map.get("charge_exchange_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setChargeExchangeRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setChargeExchangeRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setChargeExchangeRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setChargeExchangeRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setChargeExchangeRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("trade_status")) {
      Object obj = map.get("trade_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gross_profit")) {
      Object obj = map.get("gross_profit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setGrossProfit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setGrossProfit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setGrossProfit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGrossProfit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setGrossProfit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("estimate_volume")) {
      Object obj = map.get("estimate_volume");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setEstimateVolume((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setEstimateVolume(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setEstimateVolume(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setEstimateVolume(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setEstimateVolume(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("customer_type_name")) {
      Object obj = map.get("customer_type_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_grade_name")) {
      Object obj = map.get("customer_grade_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerGradeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_tags")) {
      Object obj = map.get("customer_tags");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerTags((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_code")) {
      Object obj = map.get("customer_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_discount")) {
      Object obj = map.get("customer_discount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCustomerDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCustomerDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCustomerDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCustomerDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCustomerDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("special_reminding")) {
      Object obj = map.get("special_reminding");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecialReminding((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("black_list")) {
      Object obj = map.get("black_list");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBlackList((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBlackList(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBlackList(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("trade_time")) {
      Object obj = map.get("trade_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTradeTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTradeTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTradeTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTradeTime(null);
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCountry((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("state")) {
      Object obj = map.get("state");
      if(obj != null) {
        if(obj instanceof String) {
          this.setState((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("citi")) {
      Object obj = map.get("citi");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCiti((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("district")) {
      Object obj = map.get("district");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistrict((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("town")) {
      Object obj = map.get("town");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTown((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zip")) {
      Object obj = map.get("zip");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZip((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_time")) {
      Object obj = map.get("pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPayTime(null);
      }
    }
    if(map.containsKey("country_code")) {
      Object obj = map.get("country_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCountryCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("city_code")) {
      Object obj = map.get("city_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCityCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_type")) {
      Object obj = map.get("invoice_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payer_name")) {
      Object obj = map.get("payer_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payer_regno")) {
      Object obj = map.get("payer_regno");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayerRegno((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payer_bank_account")) {
      Object obj = map.get("payer_bank_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayerBankAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payer_phone")) {
      Object obj = map.get("payer_phone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayerPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_time")) {
      Object obj = map.get("audit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuditTime(null);
      }
    }
    if(map.containsKey("payer_address")) {
      Object obj = map.get("payer_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_no")) {
      Object obj = map.get("invoice_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_code")) {
      Object obj = map.get("invoice_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("payer_bank_name")) {
      Object obj = map.get("payer_bank_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayerBankName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pre_typedetail")) {
      Object obj = map.get("pre_typedetail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreTypedetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("first_payment")) {
      Object obj = map.get("first_payment");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setFirstPayment((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setFirstPayment(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setFirstPayment(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFirstPayment(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setFirstPayment(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("final_payment")) {
      Object obj = map.get("final_payment");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setFinalPayment((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setFinalPayment(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setFinalPayment(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFinalPayment(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setFinalPayment(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("first_paytime")) {
      Object obj = map.get("first_paytime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setFirstPaytime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setFirstPaytime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFirstPaytime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setFirstPaytime(null);
      }
    }
    if(map.containsKey("final_paytime")) {
      Object obj = map.get("final_paytime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setFinalPaytime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setFinalPaytime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFinalPaytime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setFinalPaytime(null);
      }
    }
    if(map.containsKey("review_time")) {
      Object obj = map.get("review_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReviewTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setReviewTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReviewTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setReviewTime(null);
      }
    }
    if(map.containsKey("activation_time")) {
      Object obj = map.get("activation_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setActivationTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setActivationTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActivationTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setActivationTime(null);
      }
    }
    if(map.containsKey("customer_total_fee")) {
      Object obj = map.get("customer_total_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCustomerTotalFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCustomerTotalFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCustomerTotalFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCustomerTotalFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCustomerTotalFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("customer_discount_fee")) {
      Object obj = map.get("customer_discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCustomerDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCustomerDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCustomerDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCustomerDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCustomerDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("notify_pick_time")) {
      Object obj = map.get("notify_pick_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setNotifyPickTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setNotifyPickTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setNotifyPickTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setNotifyPickTime(null);
      }
    }
    if(map.containsKey("consign_time")) {
      Object obj = map.get("consign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setConsignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setConsignTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setConsignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setConsignTime(null);
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_post_fee")) {
      Object obj = map.get("customer_post_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCustomerPostFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCustomerPostFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCustomerPostFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCustomerPostFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCustomerPostFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_payment")) {
      Object obj = map.get("customer_payment");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCustomerPayment((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCustomerPayment(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCustomerPayment(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCustomerPayment(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCustomerPayment(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customize_trade_column1")) {
      Object obj = map.get("customize_trade_column1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomizeTradeColumn1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customize_trade_column2")) {
      Object obj = map.get("customize_trade_column2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomizeTradeColumn2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customize_trade_column3")) {
      Object obj = map.get("customize_trade_column3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomizeTradeColumn3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customize_trade_column4")) {
      Object obj = map.get("customize_trade_column4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomizeTradeColumn4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customize_trade_column5")) {
      Object obj = map.get("customize_trade_column5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomizeTradeColumn5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customize_trade_column6")) {
      Object obj = map.get("customize_trade_column6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomizeTradeColumn6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customize_trade_column7")) {
      Object obj = map.get("customize_trade_column7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomizeTradeColumn7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customize_trade_column8")) {
      Object obj = map.get("customize_trade_column8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomizeTradeColumn8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customize_trade_column9")) {
      Object obj = map.get("customize_trade_column9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomizeTradeColumn9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customize_trade_column10")) {
      Object obj = map.get("customize_trade_column10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomizeTradeColumn10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_bill_check")) {
      Object obj = map.get("is_bill_check");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsBillCheck((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warehouse_code")) {
      Object obj = map.get("warehouse_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarehouseCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warehouse_name")) {
      Object obj = map.get("warehouse_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarehouseName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistic_name")) {
      Object obj = map.get("logistic_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trade_id")) {
      Object obj = map.get("trade_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTradeId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTradeId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTradeId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("bill_date")) {
      Object obj = map.get("bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBillDate(null);
      }
    }
    if(map.containsKey("logistic_type")) {
      Object obj = map.get("logistic_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("main_postid")) {
      Object obj = map.get("main_postid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMainPostid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trade_type")) {
      Object obj = map.get("trade_type");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTradeType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTradeType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTradeType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("total_fee")) {
      Object obj = map.get("total_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTotalFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_fee")) {
      Object obj = map.get("tax_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("received_post_fee")) {
      Object obj = map.get("received_post_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReceivedPostFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReceivedPostFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReceivedPostFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceivedPostFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceivedPostFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discount_fee")) {
      Object obj = map.get("discount_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("payment")) {
      Object obj = map.get("payment");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayment((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayment(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayment(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayment(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayment(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("coupon_fee")) {
      Object obj = map.get("coupon_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCouponFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCouponFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCouponFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCouponFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCouponFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("received_total")) {
      Object obj = map.get("received_total");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReceivedTotal((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReceivedTotal(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReceivedTotal(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setReceivedTotal(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceivedTotal(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("post_fee")) {
      Object obj = map.get("post_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPostFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPostFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPostFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPostFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPostFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("is_table_switch")) {
      Object obj = map.get("is_table_switch");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setIsTableSwitch((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsTableSwitch(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setIsTableSwitch(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("complete_time")) {
      Object obj = map.get("complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCompleteTime(null);
      }
    }
    if(map.containsKey("shopcode")) {
      Object obj = map.get("shopcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("signing_time")) {
      Object obj = map.get("signing_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSigningTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSigningTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSigningTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSigningTime(null);
      }
    }
    if(map.containsKey("settle_audit_time")) {
      Object obj = map.get("settle_audit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSettleAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSettleAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSettleAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSettleAuditTime(null);
      }
    }
    if(map.containsKey("is_delete")) {
      Object obj = map.get("is_delete");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsDelete((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsDelete(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("local_payment")) {
      Object obj = map.get("local_payment");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setLocalPayment((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setLocalPayment(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setLocalPayment(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLocalPayment(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setLocalPayment(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("local_exchange_rate")) {
      Object obj = map.get("local_exchange_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setLocalExchangeRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setLocalExchangeRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setLocalExchangeRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLocalExchangeRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setLocalExchangeRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("customer_account")) {
      Object obj = map.get("customer_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("local_currency_code")) {
      Object obj = map.get("local_currency_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLocalCurrencyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("plat_complete_time")) {
      Object obj = map.get("plat_complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPlatCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPlatCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPlatCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPlatCompleteTime(null);
      }
    }
    if(map.containsKey("buyer_open_uid")) {
      Object obj = map.get("buyer_open_uid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerOpenUid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("qq")) {
      Object obj = map.get("qq");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQq((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trade_order_refund_time")) {
      Object obj = map.get("trade_order_refund_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeOrderRefundTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("assembly_goods_detail")) {
      Object obj = map.get("assembly_goods_detail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAssemblyGoodsDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("api_type")) {
      Object obj = map.get("api_type");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setApiType((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setApiType(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setApiType(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("logistic_code")) {
      Object obj = map.get("logistic_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("agent_shop_name")) {
      Object obj = map.get("agent_shop_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAgentShopName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trade_status_explain")) {
      Object obj = map.get("trade_status_explain");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeStatusExplain((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flag_ids")) {
      Object obj = map.get("flag_ids");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlagIds((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flag_names")) {
      Object obj = map.get("flag_names");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlagNames((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sys_flag_ids")) {
      Object obj = map.get("sys_flag_ids");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSysFlagIds((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shop_type_code")) {
      Object obj = map.get("shop_type_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("source_after_no")) {
      Object obj = map.get("source_after_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceAfterNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticket_code_list")) {
      Object obj = map.get("ticket_code_list");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTicketCodeList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("all_compass_source_content_type")) {
      Object obj = map.get("all_compass_source_content_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAllCompassSourceContentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_name")) {
      Object obj = map.get("customer_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_amount")) {
      Object obj = map.get("invoice_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("real_fee")) {
      Object obj = map.get("real_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRealFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRealFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRealFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRealFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRealFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("fin_receipt_time")) {
      Object obj = map.get("fin_receipt_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setFinReceiptTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setFinReceiptTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFinReceiptTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setFinReceiptTime(null);
      }
    }
    if(map.containsKey("extra_logistic_no")) {
      Object obj = map.get("extra_logistic_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtraLogisticNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("scroll_id")) {
      Object obj = map.get("scroll_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setScrollId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("my_gmt_create")) {
      Object obj = map.get("my_gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMyGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setMyGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMyGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setMyGmtCreate(null);
      }
    }
    if(map.containsKey("my_gmt_modified")) {
      Object obj = map.get("my_gmt_modified");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMyGmtModified(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setMyGmtModified((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMyGmtModified(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setMyGmtModified(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
