package com.xforceplus.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-11-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OmsOrderDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * OMS id
   */
  private String omsId;

  /**
   * 单号ID
   */
  private String tradeId;

  /**
   * 记录ID
   */
  private String recId;

  /**
   * 货品ID
   */
  private String goodsId;

  /**
   * 规格ID
   */
  private String specId;

  /**
   * 货品编号
   */
  private String goodsNo;

  /**
   * 品名
   */
  private String goodsName;

  /**
   * 是否组合装
   */
  private Boolean bfit;

  /**
   * 规格名
   */
  private String specName;

  /**
   * 单位
   */
  private String unit;

  /**
   * 数量
   */
  private Long goodsCount;

  /**
   * 单价
   */
  private BigDecimal price;

  /**
   * 金额
   */
  private BigDecimal goodsMoney;

  /**
   * 备注
   */
  private String remark;

  /**
   * 条码
   */
  private String barcode;

  /**
   * 是否赠品
   */
  private Boolean bgift;

  /**
   * 货位
   */
  private String positionsName;

  /**
   * 序列号
   */
  private String sn;

  /**
   * 和此订单货品关联的原始单单号
   */
  private String originalNo;

  /**
   * 分摊费用
   */
  private BigDecimal shareTradeCost;

  /**
   * 分摊优惠
   */
  private BigDecimal shareTradeFavorable;

  /**
   * 实付金额
   */
  private BigDecimal shareMoney;

  /**
   * 平台商品ID
   */
  private String platGoodsId;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime omsCreateTime;

  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime omsUdpateTime;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 组织树
   */
  private String orgTree;


  /**
   * 对一关联关系 关联对象 omsOrder
   */
    private Long omsOrderAndDetailMapId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("oms_id", omsId);
      map.put("trade_id", tradeId);
      map.put("rec_id", recId);
      map.put("goods_id", goodsId);
      map.put("spec_id", specId);
      map.put("goods_no", goodsNo);
      map.put("goods_name", goodsName);
      map.put("bfit", bfit);
      map.put("spec_name", specName);
      map.put("unit", unit);
      map.put("goods_count", goodsCount);
      map.put("price", price);
      map.put("goods_money", goodsMoney);
      map.put("remark", remark);
      map.put("barcode", barcode);
      map.put("bgift", bgift);
      map.put("positions_name", positionsName);
      map.put("sn", sn);
      map.put("original_no", originalNo);
      map.put("share_trade_cost", shareTradeCost);
      map.put("share_trade_favorable", shareTradeFavorable);
      map.put("share_money", shareMoney);
      map.put("plat_goods_id", platGoodsId);
      map.put("oms_create_time", BocpGenUtils.toTimestamp(omsCreateTime));
      map.put("oms_udpate_time", BocpGenUtils.toTimestamp(omsUdpateTime));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("org_tree", orgTree);

       map.put("omsOrderAndDetailMap.id", omsOrderAndDetailMapId);
      return map;
  }

  public static OmsOrderDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OmsOrderDetail entity = new OmsOrderDetail();
    if(map.containsKey("oms_id")) {
      Object obj = map.get("oms_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOmsId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_id")) {
      Object obj = map.get("trade_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rec_id")) {
      Object obj = map.get("rec_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_id")) {
      Object obj = map.get("goods_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("spec_id")) {
      Object obj = map.get("spec_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_no")) {
      Object obj = map.get("goods_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_name")) {
      Object obj = map.get("goods_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bfit")) {
      Object obj = map.get("bfit");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBfit((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBfit(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("spec_name")) {
      Object obj = map.get("spec_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpecName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_count")) {
      Object obj = map.get("goods_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGoodsCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodsCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodsCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("price")) {
      Object obj = map.get("price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("goods_money")) {
      Object obj = map.get("goods_money");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGoodsMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGoodsMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGoodsMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodsMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodsMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bgift")) {
      Object obj = map.get("bgift");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBgift((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBgift(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("positions_name")) {
      Object obj = map.get("positions_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPositionsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sn")) {
      Object obj = map.get("sn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("original_no")) {
      Object obj = map.get("original_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("share_trade_cost")) {
      Object obj = map.get("share_trade_cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShareTradeCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShareTradeCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShareTradeCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShareTradeCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShareTradeCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("share_trade_favorable")) {
      Object obj = map.get("share_trade_favorable");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShareTradeFavorable((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShareTradeFavorable(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShareTradeFavorable(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShareTradeFavorable(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShareTradeFavorable(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("share_money")) {
      Object obj = map.get("share_money");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setShareMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setShareMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setShareMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShareMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setShareMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("plat_goods_id")) {
      Object obj = map.get("plat_goods_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlatGoodsId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oms_create_time")) {
      Object obj = map.get("oms_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOmsCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOmsCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOmsCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOmsCreateTime(null);
      }
    }
    if(map.containsKey("oms_udpate_time")) {
      Object obj = map.get("oms_udpate_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOmsUdpateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOmsUdpateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOmsUdpateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOmsUdpateTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("omsOrderAndDetailMap.id")) {
        Object obj = map.get("omsOrderAndDetailMap.id");
      if(obj instanceof Long) {
        entity.setOmsOrderAndDetailMapId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setOmsOrderAndDetailMapId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("oms_id")) {
      Object obj = map.get("oms_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOmsId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trade_id")) {
      Object obj = map.get("trade_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rec_id")) {
      Object obj = map.get("rec_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRecId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_id")) {
      Object obj = map.get("goods_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("spec_id")) {
      Object obj = map.get("spec_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_no")) {
      Object obj = map.get("goods_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_name")) {
      Object obj = map.get("goods_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bfit")) {
      Object obj = map.get("bfit");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setBfit((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBfit(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("spec_name")) {
      Object obj = map.get("spec_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpecName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_count")) {
      Object obj = map.get("goods_count");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGoodsCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGoodsCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setGoodsCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("price")) {
      Object obj = map.get("price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("goods_money")) {
      Object obj = map.get("goods_money");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setGoodsMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setGoodsMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setGoodsMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGoodsMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setGoodsMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bgift")) {
      Object obj = map.get("bgift");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setBgift((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBgift(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("positions_name")) {
      Object obj = map.get("positions_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPositionsName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sn")) {
      Object obj = map.get("sn");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSn((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("original_no")) {
      Object obj = map.get("original_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("share_trade_cost")) {
      Object obj = map.get("share_trade_cost");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setShareTradeCost((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setShareTradeCost(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setShareTradeCost(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setShareTradeCost(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setShareTradeCost(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("share_trade_favorable")) {
      Object obj = map.get("share_trade_favorable");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setShareTradeFavorable((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setShareTradeFavorable(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setShareTradeFavorable(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setShareTradeFavorable(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setShareTradeFavorable(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("share_money")) {
      Object obj = map.get("share_money");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setShareMoney((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setShareMoney(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setShareMoney(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setShareMoney(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setShareMoney(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("plat_goods_id")) {
      Object obj = map.get("plat_goods_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlatGoodsId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oms_create_time")) {
      Object obj = map.get("oms_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOmsCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOmsCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOmsCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOmsCreateTime(null);
      }
    }
    if(map.containsKey("oms_udpate_time")) {
      Object obj = map.get("oms_udpate_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOmsUdpateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOmsUdpateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOmsUdpateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOmsUdpateTime(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("omsOrderAndDetailMap.id")) {
        Object obj = map.get("omsOrderAndDetailMap.id");
        if(obj instanceof Long) {
          this.setOmsOrderAndDetailMapId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOmsOrderAndDetailMapId(Long.parseLong((String)obj));
        }
      }
  }
}
