package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * check_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-10
 */
public enum CheckStatus {

    _1("1", "待对账"),
    _2("2", "已对账"),
    _0("0", "未对账"),
    __1("-1", "无需对账");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CheckStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "0":
                return _0;
            case "-1":
                return __1;
            default:
                return null;
        }
    }
}
