package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * contract_debt_flag
 * </p>
 *
 * @author ultraman
 * @since 2024-12-10
 */
public enum ContractDebtFlag {

    NO("no", "否"),
    YES("yes", "是");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ContractDebtFlag(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ContractDebtFlag fromCode(String code){
        switch(code) {
            case "no":
                return NO;
            case "yes":
                return YES;
            default:
                return null;
        }
    }
}
