package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * deal_status
 * </p>
 *
 * @author ultraman
 * @since 2024-12-10
 */
public enum DealStatus {

    _1("1", "已处理待对账"),
    _2("2", "待处理"),
    _4("4", "已生成应收订单"),
    _3("3", "待确认应收订单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DealStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DealStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "4":
                return _4;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
