package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * dy_order_statys
 * </p>
 *
 * @author ultraman
 * @since 2024-12-10
 */
public enum DyOrderStatys {

    _1("1", "待确认/待支付"),
    _2("2", "备货中"),
    _3("3", "已发货（全部发货）"),
    _4("4", "已取消"),
    _5("5", "已完成（已收货）"),
    _101("101", "部分发货"),
    _105("105", "已支付"),
    _6("6", "-"),
    _102("102", "-"),
    _103("103", "-"),
    _104("104", "-");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DyOrderStatys(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DyOrderStatys fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "101":
                return _101;
            case "105":
                return _105;
            case "6":
                return _6;
            case "102":
                return _102;
            case "103":
                return _103;
            case "104":
                return _104;
            default:
                return null;
        }
    }
}
