package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * jky_pay_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-10
 */
public enum JkyPayType {

    _1("1", "支付宝"),
    _2("2", "财付通"),
    _3("3", "微信支付"),
    _4("4", "银联支付"),
    _5("5", "盛付通"),
    _6("6", "其他"),
    _7("7", "现金"),
    _8("8", "储值卡"),
    _9("9", "扫码付"),
    _10("10", "挂账"),
    _11("11", "诺诺支付"),
    _16("16", "易付宝"),
    _27("27", "通联支付"),
    _32("32", "有赞支付"),
    _33("33", "汇付支付"),
    _35("35", "易宝支付"),
    _37("37", "汇聚支付"),
    _38("38", "合利宝支付");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    JkyPayType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static JkyPayType fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            case "9":
                return _9;
            case "10":
                return _10;
            case "11":
                return _11;
            case "16":
                return _16;
            case "27":
                return _27;
            case "32":
                return _32;
            case "33":
                return _33;
            case "35":
                return _35;
            case "37":
                return _37;
            case "38":
                return _38;
            default:
                return null;
        }
    }
}
