package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * kshandling_way
 * </p>
 *
 * @author ultraman
 * @since 2024-12-10
 */
public enum KshandlingWay {

    _1("1", "退货退款"),
    _10("10", "仅退款"),
    _3("3", "换货");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    KshandlingWay(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static KshandlingWay fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "10":
                return _10;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
