package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * oms_after_sale_return_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-10
 */
public enum OmsAfterSaleReturnType {

    退("退", "只有退货"),
    换("换", "有换货");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    OmsAfterSaleReturnType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OmsAfterSaleReturnType fromCode(String code){
        switch(code) {
            case "退":
                return 退;
            case "换":
                return 换;
            default:
                return null;
        }
    }
}
