package com.xforceplus.policymanagement.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * variable_type
 * </p>
 *
 * @author ultraman
 * @since 2024-12-10
 */
public enum VariableType {

    FORM_VARIABLE("formVariable", "表单变量"),
    SYSTEM_VARIABLE("systemVariable", "系统变量"),
    CUSTOM_VARIABLE("customVariable", "自定义变量");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    VariableType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static VariableType fromCode(String code){
        switch(code) {
            case "formVariable":
                return FORM_VARIABLE;
            case "systemVariable":
                return SYSTEM_VARIABLE;
            case "customVariable":
                return CUSTOM_VARIABLE;
            default:
                return null;
        }
    }
}
