package com.xforceplus.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-12-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class KsAfterSale implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 租户code
   */
  private String ksTenantCode;

  /**
   * 数据创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 单据流转处理状态
   */
  private String dealStatus;

  /**
   * 对账状态
   */
  @TableField("checkStatus")
  private String checkStatus;

  /**
   * 业务ID
   */
  private String businessId;

  /**
   * 数据MD5
   */
  @TableField("dataMD5")
  private String dataMD5;

  /**
   * 异常信息
   */
  private String errorMsg;

  /**
   * 快手ID
   */
  private Long ksId;

  /**
   * 对账金额
   */
  private BigDecimal checkAmount;

  /**
   * 店铺名称
   */
  private String shopName;

  /**
   * 事业部名称
   */
  private String bussinessUnitName;

  /**
   * 公司名称
   */
  private String companyName;

  /**
   * 公司税号
   */
  private String companyTaxNo;

  /**
   * 最新版本
   */
  private Boolean latest;

  /**
   * 账期
   */
  private String accountPeriod;

  /**
   * 店铺id
   */
  private String shopId;

  /**
   * 订单Id
   */
  private String oid;

  /**
   * 售后单id
   */
  private String refundId;

  /**
   * 商家实退金额
   */
  private BigDecimal refundFee;

  /**
   * 商品的skuid
   */
  private String skuId;

  /**
   * 退款原因
   */
  private String refundReason;

  /**
   * 退款状态
   */
  private String status;

  /**
   * 买家快手id
   */
  private String buyerId;

  /**
   * 退款类型
   */
  private String refundType;

  /**
   * 卖家快手id
   */
  private String sellerId;

  /**
   * 退款描述
   */
  private String refundDesc;

  /**
   * 退货申请时间
   */
  private Long submitTime;

  /**
   * 服务商商品id
   */
  private String relItemId;

  /**
   * 协商相关核心信息变更时间
   */
  private Long negotiateUpdateTime;

  /**
   * 更新时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime ksUpdateTime;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime ksCreateTime;

  /**
   * 服务商skuid
   */
  private String relSkuId;

  /**
   * sku编码
   */
  private String skuNick;

  /**
   * 物流id
   */
  private Long logisticsId;

  /**
   * 结束时间（退款成功或退款失败时间）
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime endTime;

  /**
   * 快手商品id
   */
  private String itemId;

  /**
   * 退款原因文字说明
   */
  private String refundReasonDesc;

  /**
   * 退款超时时间
   */
  private Long expireTime;

  /**
   * submit_time的19位
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime mySubmitTime;

  /**
   * end_time的19位
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime myEndTime;

  /**
   * 货物状态
   */
  private String receiptStatus;

  /**
   * 退款方式
   */
  private String handlingWay;

  /**
   * 协商状态
   */
  private String negotiateStatus;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("ks_tenant_code", ksTenantCode);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("deal_status", dealStatus);
      map.put("checkStatus", checkStatus);
      map.put("business_id", businessId);
      map.put("dataMD5", dataMD5);
      map.put("error_msg", errorMsg);
      map.put("ks_id", ksId);
      map.put("check_amount", checkAmount);
      map.put("shop_name", shopName);
      map.put("bussiness_unit_name", bussinessUnitName);
      map.put("company_name", companyName);
      map.put("company_tax_no", companyTaxNo);
      map.put("latest", latest);
      map.put("account_period", accountPeriod);
      map.put("shop_id", shopId);
      map.put("oid", oid);
      map.put("refund_id", refundId);
      map.put("refund_fee", refundFee);
      map.put("sku_id", skuId);
      map.put("refund_reason", refundReason);
      map.put("status", status);
      map.put("buyer_id", buyerId);
      map.put("refund_type", refundType);
      map.put("seller_id", sellerId);
      map.put("refund_desc", refundDesc);
      map.put("submit_time", submitTime);
      map.put("rel_item_id", relItemId);
      map.put("negotiate_update_time", negotiateUpdateTime);
      map.put("ks_update_time", BocpGenUtils.toTimestamp(ksUpdateTime));
      map.put("ks_create_time", BocpGenUtils.toTimestamp(ksCreateTime));
      map.put("rel_sku_id", relSkuId);
      map.put("sku_nick", skuNick);
      map.put("logistics_id", logisticsId);
      map.put("end_time", BocpGenUtils.toTimestamp(endTime));
      map.put("item_id", itemId);
      map.put("refund_reason_desc", refundReasonDesc);
      map.put("expire_time", expireTime);
      map.put("my_submit_time", BocpGenUtils.toTimestamp(mySubmitTime));
      map.put("my_end_time", BocpGenUtils.toTimestamp(myEndTime));
      map.put("receipt_status", receiptStatus);
      map.put("handling_way", handlingWay);
      map.put("negotiate_status", negotiateStatus);
      map.put("org_tree", orgTree);

      return map;
  }

  public static KsAfterSale fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    KsAfterSale entity = new KsAfterSale();
    if(map.containsKey("ks_tenant_code")) {
      Object obj = map.get("ks_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKsTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ks_id")) {
      Object obj = map.get("ks_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setKsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setKsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setKsId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("oid")) {
      Object obj = map.get("oid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_id")) {
      Object obj = map.get("refund_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_fee")) {
      Object obj = map.get("refund_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRefundFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRefundFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRefundFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRefundFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sku_id")) {
      Object obj = map.get("sku_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSkuId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_reason")) {
      Object obj = map.get("refund_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_id")) {
      Object obj = map.get("buyer_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_type")) {
      Object obj = map.get("refund_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_id")) {
      Object obj = map.get("seller_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_desc")) {
      Object obj = map.get("refund_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("submit_time")) {
      Object obj = map.get("submit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSubmitTime((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSubmitTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSubmitTime(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("rel_item_id")) {
      Object obj = map.get("rel_item_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRelItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("negotiate_update_time")) {
      Object obj = map.get("negotiate_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setNegotiateUpdateTime((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNegotiateUpdateTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNegotiateUpdateTime(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("ks_update_time")) {
      Object obj = map.get("ks_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setKsUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setKsUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setKsUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setKsUpdateTime(null);
      }
    }
    if(map.containsKey("ks_create_time")) {
      Object obj = map.get("ks_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setKsCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setKsCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setKsCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setKsCreateTime(null);
      }
    }
    if(map.containsKey("rel_sku_id")) {
      Object obj = map.get("rel_sku_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRelSkuId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sku_nick")) {
      Object obj = map.get("sku_nick");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSkuNick((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistics_id")) {
      Object obj = map.get("logistics_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLogisticsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLogisticsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLogisticsId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("end_time")) {
      Object obj = map.get("end_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setEndTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setEndTime(null);
      }
    }
    if(map.containsKey("item_id")) {
      Object obj = map.get("item_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_reason_desc")) {
      Object obj = map.get("refund_reason_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundReasonDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expire_time")) {
      Object obj = map.get("expire_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExpireTime((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpireTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExpireTime(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("my_submit_time")) {
      Object obj = map.get("my_submit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMySubmitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setMySubmitTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMySubmitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMySubmitTime(null);
      }
    }
    if(map.containsKey("my_end_time")) {
      Object obj = map.get("my_end_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setMyEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setMyEndTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMyEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setMyEndTime(null);
      }
    }
    if(map.containsKey("receipt_status")) {
      Object obj = map.get("receipt_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiptStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("handling_way")) {
      Object obj = map.get("handling_way");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHandlingWay((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("negotiate_status")) {
      Object obj = map.get("negotiate_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNegotiateStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("ks_tenant_code")) {
      Object obj = map.get("ks_tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKsTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ks_id")) {
      Object obj = map.get("ks_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setKsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setKsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setKsId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBussinessUnitName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("oid")) {
      Object obj = map.get("oid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_id")) {
      Object obj = map.get("refund_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_fee")) {
      Object obj = map.get("refund_fee");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRefundFee((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRefundFee(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRefundFee(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRefundFee(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRefundFee(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sku_id")) {
      Object obj = map.get("sku_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSkuId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_reason")) {
      Object obj = map.get("refund_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_id")) {
      Object obj = map.get("buyer_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_type")) {
      Object obj = map.get("refund_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_id")) {
      Object obj = map.get("seller_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_desc")) {
      Object obj = map.get("refund_desc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("submit_time")) {
      Object obj = map.get("submit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSubmitTime((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSubmitTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSubmitTime(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("rel_item_id")) {
      Object obj = map.get("rel_item_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRelItemId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("negotiate_update_time")) {
      Object obj = map.get("negotiate_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setNegotiateUpdateTime((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setNegotiateUpdateTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setNegotiateUpdateTime(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("ks_update_time")) {
      Object obj = map.get("ks_update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setKsUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setKsUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setKsUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setKsUpdateTime(null);
      }
    }
    if(map.containsKey("ks_create_time")) {
      Object obj = map.get("ks_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setKsCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setKsCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setKsCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setKsCreateTime(null);
      }
    }
    if(map.containsKey("rel_sku_id")) {
      Object obj = map.get("rel_sku_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRelSkuId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sku_nick")) {
      Object obj = map.get("sku_nick");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSkuNick((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistics_id")) {
      Object obj = map.get("logistics_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLogisticsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLogisticsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setLogisticsId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("end_time")) {
      Object obj = map.get("end_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setEndTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setEndTime(null);
      }
    }
    if(map.containsKey("item_id")) {
      Object obj = map.get("item_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_reason_desc")) {
      Object obj = map.get("refund_reason_desc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundReasonDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expire_time")) {
      Object obj = map.get("expire_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExpireTime((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpireTime(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setExpireTime(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("my_submit_time")) {
      Object obj = map.get("my_submit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMySubmitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setMySubmitTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMySubmitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setMySubmitTime(null);
      }
    }
    if(map.containsKey("my_end_time")) {
      Object obj = map.get("my_end_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setMyEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setMyEndTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMyEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setMyEndTime(null);
      }
    }
    if(map.containsKey("receipt_status")) {
      Object obj = map.get("receipt_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiptStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("handling_way")) {
      Object obj = map.get("handling_way");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHandlingWay((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("negotiate_status")) {
      Object obj = map.get("negotiate_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNegotiateStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
