package com.xforceplus.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-12-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PddSalesOrder implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * id
   */
  private Long pddId;

  /**
   * 租户编码
   */
  private String pddTenantCode;

  /**
   * 店铺编号
   */
  private String shopId;

  /**
   * 详细地址（加密）
   */
  private String address;

  /**
   * 详细地址(打码)
   */
  private String addressMask;

  /**
   * 售后状态
   */
  private String afterSalesStatus;

  /**
   * 保税仓名称
   */
  private String bondedWarehouse;

  /**
   * 买家留言信息
   */
  private String buyerMemo;

  /**
   * 团长免单金额
   */
  private String capitalFreeDiscount;

  /**
   * 卡号信息列表
   */
  private String cardInfoList;

  /**
   * 商品一级分类
   */
  private Long catId1;

  /**
   * 商品二级分类
   */
  private Long catId2;

  /**
   * 商品三级分类
   */
  private Long catId3;

  /**
   * 商品四级分类
   */
  private Long catId4;

  /**
   * 城市
   */
  private String city;

  /**
   * 城市编码
   */
  private Long cityId;

  /**
   * 成交时间
   */
  private String confirmTime;

  /**
   * 集运信息
   */
  private String consolidateInfo;

  /**
   * 国家或地区
   */
  private String country;

  /**
   * 国家或地区编码
   */
  private Long countryId;

  /**
   * 订单创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createdTime;

  /**
   * 送货入户费用
   */
  private BigDecimal deliveryHomeValue;

  /**
   * 送货入户并安装费用
   */
  private BigDecimal deliveryInstallValue;

  /**
   * 是否当日发货
   */
  private Boolean deliveryOneDay;

  /**
   * 折扣金额
   */
  private BigDecimal discountAmount;

  /**
   * 多多支付立减金额
   */
  private String duoDuoPayReduction;

  /**
   * 是否多多批发
   */
  private Boolean duoduoWholesale;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 订单多包裹发货时使用的其他发货快递信息
   */
  private String extraDeliveryList;

  /**
   * 是否顺丰包邮
   */
  private Boolean freeSf;

  /**
   * 赠品额外运单列表
   */
  private String giftDeliveryList;

  /**
   * 赠品列表
   */
  private String giftList;

  /**
   * 商品金额
   */
  private BigDecimal goodsAmount;

  /**
   * 团id
   */
  private Long groupOrderId;

  /**
   * 上门安装费用
   */
  private BigDecimal homeInstallValue;

  /**
   * 发票申请
   */
  private Boolean invoiceStatus;

  /**
   * 是否是抽奖订单
   */
  private String isLuckyFlag;

  /**
   * 是否为预售商品
   */
  private Boolean isPreSale;

  /**
   * 是否缺货
   */
  private Boolean isStockOut;

  /**
   * 订单承诺发货时间
   */
  private String lastShipTime;

  /**
   * 快递公司在拼多多的代码
   */
  private Long logisticsId;

  /**
   * 只换不修
   */
  private Boolean onlySupportReplace;

  /**
   * 合单ID
   */
  private String openAddressId;

  /**
   * 订单改价折扣金额
   */
  private BigDecimal orderChangeAmount;

  /**
   * 订单编号
   */
  private String orderSn;

  /**
   * 订单状态
   */
  private String orderStatus;

  /**
   * 支付金额
   */
  private BigDecimal payAmount;

  /**
   * 支付单号
   */
  private String payNo;

  /**
   * 支付时间
   */
  private String payTime;

  /**
   * 平台优惠金额
   */
  private BigDecimal platformDiscount;

  /**
   * 邮费
   */
  private BigDecimal postage;

  /**
   * 预售时间
   */
  private String preSaleTime;

  /**
   * 省份
   */
  private String province;

  /**
   * 省份编码
   */
  private Long provinceId;

  /**
   * 确认收货时间
   */
  private String receiveTime;

  /**
   * 密文收件人地址不拼接省市区
   */
  private String receiverAddress;

  /**
   * 收件人姓名（打码）
   */
  private String receiverAddressMask;

  /**
   * 收件人电话密文
   */
  private String receiverPhone;

  /**
   * 收件人手机号（打码）
   */
  private String receiverPhoneMask;

  /**
   * 售后状态
   */
  private Long refundStatus;

  /**
   * 订单备注
   */
  private String remark;

  /**
   * 订单审核状态
   */
  private String riskControlStatus;

  /**
   * 是否门店自提
   */
  private Boolean selfContained;

  /**
   * 商家优惠金额
   */
  private BigDecimal sellerDiscount;

  /**
   * 服务费明细列表
   */
  private String serviceFeeDetail;

  /**
   * 关联的加运费发顺丰的补差价订单
   */
  private String shipAdditionalLinkOrder;

  /**
   * 运费补差价订单的原单
   */
  private String shipAdditionalOriginOrder;

  /**
   * 发货时间
   */
  private String shippingTime;

  /**
   * 创建交易时的物流方式
   */
  private String shippingType;

  /**
   * 订单信息
   */
  private String stepOrderInfo;

  /**
   * 缺货处理状态
   */
  private String stockOutHandleStatus;

  /**
   * 全国联保
   */
  private Boolean supportNationwideWarranty;

  /**
   * 区乡镇
   */
  private String town;

  /**
   * 区县编码
   */
  private Long townId;

  /**
   * 快递单号
   */
  private String trackingNumber;

  /**
   * 订单类型
   */
  private String tradeType;

  /**
   * 订单的更新时间
   */
  private String updatedAt;

  /**
   * 催发货时间
   */
  private String urgeShippingTime;

  /**
   * 预约配送日期
   */
  private String yypsDate;

  /**
   * 预约配送时段
   */
  private String yypsTime;

  /**
   * 系统创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime gmtCreate;

  /**
   * 标签列表
   */
  private String orderTagList;

  /**
   * 业务ID
   */
  private String businessId;

  /**
   * 对账状态
   */
  @TableField("checkStatus")
  private String checkStatus;

  /**
   * 数据MD5
   */
  @TableField("dataMD5")
  private String dataMD5;

  /**
   * 异常信息
   */
  private String errorMsg;

  /**
   * 数据流转状态
   */
  private String dealStatus;

  /**
   * 最新版本
   */
  private Boolean latest;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;

  /**
   * 对账金额
   */
  private BigDecimal checkAmount;

  /**
   * 事业部名称
   */
  private String bussinessUnitName;

  /**
   * 店铺名称
   */
  private String shopName;

  /**
   * 公司名称
   */
  private String companyName;

  /**
   * 公司税号
   */
  private String companyTaxNo;

  /**
   * 账期
   */
  private String accountPeriod;

  /**
   * 支付方式
   */
  private String payType;

  /**
   * 市场业务类型
   */
  private String mktBizType;

  /**
   * 送货入户并安装服务
   */
  private String homeDeliveryType;

  /**
   * 成团状态
   */
  private String groupStatus;

  /**
   * 团身份
   */
  private String groupRole;

  /**
   * 成交状态
   */
  private String confirmStatus;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("pdd_id", pddId);
      map.put("pdd_tenant_code", pddTenantCode);
      map.put("shop_id", shopId);
      map.put("address", address);
      map.put("address_mask", addressMask);
      map.put("after_sales_status", afterSalesStatus);
      map.put("bonded_warehouse", bondedWarehouse);
      map.put("buyer_memo", buyerMemo);
      map.put("capital_free_discount", capitalFreeDiscount);
      map.put("card_info_list", cardInfoList);
      map.put("cat_id1", catId1);
      map.put("cat_id2", catId2);
      map.put("cat_id3", catId3);
      map.put("cat_id4", catId4);
      map.put("city", city);
      map.put("city_id", cityId);
      map.put("confirm_time", confirmTime);
      map.put("consolidate_info", consolidateInfo);
      map.put("country", country);
      map.put("country_id", countryId);
      map.put("created_time", BocpGenUtils.toTimestamp(createdTime));
      map.put("delivery_home_value", deliveryHomeValue);
      map.put("delivery_install_value", deliveryInstallValue);
      map.put("delivery_one_day", deliveryOneDay);
      map.put("discount_amount", discountAmount);
      map.put("duo_duo_pay_reduction", duoDuoPayReduction);
      map.put("duoduo_wholesale", duoduoWholesale);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("extra_delivery_list", extraDeliveryList);
      map.put("free_sf", freeSf);
      map.put("gift_delivery_list", giftDeliveryList);
      map.put("gift_list", giftList);
      map.put("goods_amount", goodsAmount);
      map.put("group_order_id", groupOrderId);
      map.put("home_install_value", homeInstallValue);
      map.put("invoice_status", invoiceStatus);
      map.put("is_lucky_flag", isLuckyFlag);
      map.put("is_pre_sale", isPreSale);
      map.put("is_stock_out", isStockOut);
      map.put("last_ship_time", lastShipTime);
      map.put("logistics_id", logisticsId);
      map.put("only_support_replace", onlySupportReplace);
      map.put("open_address_id", openAddressId);
      map.put("order_change_amount", orderChangeAmount);
      map.put("order_sn", orderSn);
      map.put("order_status", orderStatus);
      map.put("pay_amount", payAmount);
      map.put("pay_no", payNo);
      map.put("pay_time", payTime);
      map.put("platform_discount", platformDiscount);
      map.put("postage", postage);
      map.put("pre_sale_time", preSaleTime);
      map.put("province", province);
      map.put("province_id", provinceId);
      map.put("receive_time", receiveTime);
      map.put("receiver_address", receiverAddress);
      map.put("receiver_address_mask", receiverAddressMask);
      map.put("receiver_phone", receiverPhone);
      map.put("receiver_phone_mask", receiverPhoneMask);
      map.put("refund_status", refundStatus);
      map.put("remark", remark);
      map.put("risk_control_status", riskControlStatus);
      map.put("self_contained", selfContained);
      map.put("seller_discount", sellerDiscount);
      map.put("service_fee_detail", serviceFeeDetail);
      map.put("ship_additional_link_order", shipAdditionalLinkOrder);
      map.put("ship_additional_origin_order", shipAdditionalOriginOrder);
      map.put("shipping_time", shippingTime);
      map.put("shipping_type", shippingType);
      map.put("step_order_info", stepOrderInfo);
      map.put("stock_out_handle_status", stockOutHandleStatus);
      map.put("support_nationwide_warranty", supportNationwideWarranty);
      map.put("town", town);
      map.put("town_id", townId);
      map.put("tracking_number", trackingNumber);
      map.put("trade_type", tradeType);
      map.put("updated_at", updatedAt);
      map.put("urge_shipping_time", urgeShippingTime);
      map.put("yyps_date", yypsDate);
      map.put("yyps_time", yypsTime);
      map.put("gmt_create", BocpGenUtils.toTimestamp(gmtCreate));
      map.put("order_tag_list", orderTagList);
      map.put("business_id", businessId);
      map.put("checkStatus", checkStatus);
      map.put("dataMD5", dataMD5);
      map.put("error_msg", errorMsg);
      map.put("deal_status", dealStatus);
      map.put("latest", latest);
      map.put("versionNo", versionNo);
      map.put("check_amount", checkAmount);
      map.put("bussiness_unit_name", bussinessUnitName);
      map.put("shop_name", shopName);
      map.put("company_name", companyName);
      map.put("company_tax_no", companyTaxNo);
      map.put("account_period", accountPeriod);
      map.put("pay_type", payType);
      map.put("mkt_biz_type", mktBizType);
      map.put("home_delivery_type", homeDeliveryType);
      map.put("group_status", groupStatus);
      map.put("group_role", groupRole);
      map.put("confirm_status", confirmStatus);
      map.put("org_tree", orgTree);

      return map;
  }

  public static PddSalesOrder fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PddSalesOrder entity = new PddSalesOrder();
    if(map.containsKey("pdd_id")) {
      Object obj = map.get("pdd_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPddId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPddId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPddId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pdd_tenant_code")) {
      Object obj = map.get("pdd_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPddTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("address")) {
      Object obj = map.get("address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("address_mask")) {
      Object obj = map.get("address_mask");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddressMask((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("after_sales_status")) {
      Object obj = map.get("after_sales_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAfterSalesStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bonded_warehouse")) {
      Object obj = map.get("bonded_warehouse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBondedWarehouse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_memo")) {
      Object obj = map.get("buyer_memo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerMemo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("capital_free_discount")) {
      Object obj = map.get("capital_free_discount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCapitalFreeDiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("card_info_list")) {
      Object obj = map.get("card_info_list");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCardInfoList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cat_id1")) {
      Object obj = map.get("cat_id1");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCatId1((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCatId1(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCatId1(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cat_id2")) {
      Object obj = map.get("cat_id2");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCatId2((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCatId2(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCatId2(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cat_id3")) {
      Object obj = map.get("cat_id3");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCatId3((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCatId3(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCatId3(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("cat_id4")) {
      Object obj = map.get("cat_id4");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCatId4((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCatId4(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCatId4(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("city_id")) {
      Object obj = map.get("city_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCityId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCityId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCityId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("confirm_time")) {
      Object obj = map.get("confirm_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConfirmTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("consolidate_info")) {
      Object obj = map.get("consolidate_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConsolidateInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("country_id")) {
      Object obj = map.get("country_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCountryId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCountryId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCountryId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("created_time")) {
      Object obj = map.get("created_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreatedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreatedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreatedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreatedTime(null);
      }
    }
    if(map.containsKey("delivery_home_value")) {
      Object obj = map.get("delivery_home_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDeliveryHomeValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDeliveryHomeValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDeliveryHomeValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeliveryHomeValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeliveryHomeValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("delivery_install_value")) {
      Object obj = map.get("delivery_install_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDeliveryInstallValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDeliveryInstallValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDeliveryInstallValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeliveryInstallValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDeliveryInstallValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("delivery_one_day")) {
      Object obj = map.get("delivery_one_day");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setDeliveryOneDay((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDeliveryOneDay(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("discount_amount")) {
      Object obj = map.get("discount_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDiscountAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("duo_duo_pay_reduction")) {
      Object obj = map.get("duo_duo_pay_reduction");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDuoDuoPayReduction((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("duoduo_wholesale")) {
      Object obj = map.get("duoduo_wholesale");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setDuoduoWholesale((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDuoduoWholesale(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extra_delivery_list")) {
      Object obj = map.get("extra_delivery_list");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtraDeliveryList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("free_sf")) {
      Object obj = map.get("free_sf");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setFreeSf((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFreeSf(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("gift_delivery_list")) {
      Object obj = map.get("gift_delivery_list");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGiftDeliveryList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gift_list")) {
      Object obj = map.get("gift_list");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGiftList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_amount")) {
      Object obj = map.get("goods_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGoodsAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGoodsAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGoodsAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGoodsAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGoodsAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("group_order_id")) {
      Object obj = map.get("group_order_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGroupOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGroupOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGroupOrderId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("home_install_value")) {
      Object obj = map.get("home_install_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setHomeInstallValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setHomeInstallValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setHomeInstallValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setHomeInstallValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setHomeInstallValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setInvoiceStatus((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceStatus(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("is_lucky_flag")) {
      Object obj = map.get("is_lucky_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsLuckyFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_pre_sale")) {
      Object obj = map.get("is_pre_sale");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsPreSale((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsPreSale(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("is_stock_out")) {
      Object obj = map.get("is_stock_out");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setIsStockOut((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setIsStockOut(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("last_ship_time")) {
      Object obj = map.get("last_ship_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastShipTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistics_id")) {
      Object obj = map.get("logistics_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLogisticsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLogisticsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLogisticsId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("only_support_replace")) {
      Object obj = map.get("only_support_replace");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setOnlySupportReplace((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOnlySupportReplace(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("open_address_id")) {
      Object obj = map.get("open_address_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpenAddressId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_change_amount")) {
      Object obj = map.get("order_change_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderChangeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderChangeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderChangeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderChangeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderChangeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("order_sn")) {
      Object obj = map.get("order_sn");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderSn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pay_no")) {
      Object obj = map.get("pay_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_time")) {
      Object obj = map.get("pay_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("platform_discount")) {
      Object obj = map.get("platform_discount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPlatformDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPlatformDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPlatformDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPlatformDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPlatformDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("postage")) {
      Object obj = map.get("postage");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPostage((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPostage(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPostage(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPostage(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPostage(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pre_sale_time")) {
      Object obj = map.get("pre_sale_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPreSaleTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("province")) {
      Object obj = map.get("province");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProvince((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("province_id")) {
      Object obj = map.get("province_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setProvinceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setProvinceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setProvinceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("receive_time")) {
      Object obj = map.get("receive_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiver_address")) {
      Object obj = map.get("receiver_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiverAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiver_address_mask")) {
      Object obj = map.get("receiver_address_mask");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiverAddressMask((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiver_phone")) {
      Object obj = map.get("receiver_phone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiverPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiver_phone_mask")) {
      Object obj = map.get("receiver_phone_mask");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiverPhoneMask((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_status")) {
      Object obj = map.get("refund_status");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRefundStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRefundStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("risk_control_status")) {
      Object obj = map.get("risk_control_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRiskControlStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("self_contained")) {
      Object obj = map.get("self_contained");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setSelfContained((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSelfContained(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("seller_discount")) {
      Object obj = map.get("seller_discount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSellerDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSellerDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSellerDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("service_fee_detail")) {
      Object obj = map.get("service_fee_detail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setServiceFeeDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ship_additional_link_order")) {
      Object obj = map.get("ship_additional_link_order");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipAdditionalLinkOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ship_additional_origin_order")) {
      Object obj = map.get("ship_additional_origin_order");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipAdditionalOriginOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipping_time")) {
      Object obj = map.get("shipping_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShippingTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipping_type")) {
      Object obj = map.get("shipping_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShippingType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("step_order_info")) {
      Object obj = map.get("step_order_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStepOrderInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stock_out_handle_status")) {
      Object obj = map.get("stock_out_handle_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStockOutHandleStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("support_nationwide_warranty")) {
      Object obj = map.get("support_nationwide_warranty");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setSupportNationwideWarranty((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSupportNationwideWarranty(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("town")) {
      Object obj = map.get("town");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTown((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("town_id")) {
      Object obj = map.get("town_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTownId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTownId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTownId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tracking_number")) {
      Object obj = map.get("tracking_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTrackingNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trade_type")) {
      Object obj = map.get("trade_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTradeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("updated_at")) {
      Object obj = map.get("updated_at");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdatedAt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("urge_shipping_time")) {
      Object obj = map.get("urge_shipping_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUrgeShippingTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("yyps_date")) {
      Object obj = map.get("yyps_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYypsDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("yyps_time")) {
      Object obj = map.get("yyps_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYypsTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGmtCreate(null);
      }
    }
    if(map.containsKey("order_tag_list")) {
      Object obj = map.get("order_tag_list");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderTagList((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mkt_biz_type")) {
      Object obj = map.get("mkt_biz_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMktBizType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("home_delivery_type")) {
      Object obj = map.get("home_delivery_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHomeDeliveryType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("group_status")) {
      Object obj = map.get("group_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGroupStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("group_role")) {
      Object obj = map.get("group_role");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGroupRole((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("confirm_status")) {
      Object obj = map.get("confirm_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConfirmStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("pdd_id")) {
      Object obj = map.get("pdd_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPddId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPddId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPddId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("pdd_tenant_code")) {
      Object obj = map.get("pdd_tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPddTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shop_id")) {
      Object obj = map.get("shop_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("address")) {
      Object obj = map.get("address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("address_mask")) {
      Object obj = map.get("address_mask");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddressMask((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("after_sales_status")) {
      Object obj = map.get("after_sales_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAfterSalesStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bonded_warehouse")) {
      Object obj = map.get("bonded_warehouse");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBondedWarehouse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_memo")) {
      Object obj = map.get("buyer_memo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerMemo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("capital_free_discount")) {
      Object obj = map.get("capital_free_discount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCapitalFreeDiscount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("card_info_list")) {
      Object obj = map.get("card_info_list");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCardInfoList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cat_id1")) {
      Object obj = map.get("cat_id1");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCatId1((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCatId1(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCatId1(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("cat_id2")) {
      Object obj = map.get("cat_id2");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCatId2((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCatId2(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCatId2(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("cat_id3")) {
      Object obj = map.get("cat_id3");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCatId3((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCatId3(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCatId3(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("cat_id4")) {
      Object obj = map.get("cat_id4");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCatId4((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCatId4(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCatId4(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("city")) {
      Object obj = map.get("city");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("city_id")) {
      Object obj = map.get("city_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCityId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCityId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCityId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("confirm_time")) {
      Object obj = map.get("confirm_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfirmTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("consolidate_info")) {
      Object obj = map.get("consolidate_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConsolidateInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCountry((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("country_id")) {
      Object obj = map.get("country_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCountryId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCountryId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCountryId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("created_time")) {
      Object obj = map.get("created_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreatedTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreatedTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreatedTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreatedTime(null);
      }
    }
    if(map.containsKey("delivery_home_value")) {
      Object obj = map.get("delivery_home_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDeliveryHomeValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDeliveryHomeValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDeliveryHomeValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeliveryHomeValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDeliveryHomeValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("delivery_install_value")) {
      Object obj = map.get("delivery_install_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDeliveryInstallValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDeliveryInstallValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDeliveryInstallValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeliveryInstallValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDeliveryInstallValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("delivery_one_day")) {
      Object obj = map.get("delivery_one_day");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setDeliveryOneDay((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDeliveryOneDay(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("discount_amount")) {
      Object obj = map.get("discount_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDiscountAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("duo_duo_pay_reduction")) {
      Object obj = map.get("duo_duo_pay_reduction");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDuoDuoPayReduction((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("duoduo_wholesale")) {
      Object obj = map.get("duoduo_wholesale");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setDuoduoWholesale((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDuoduoWholesale(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extra_delivery_list")) {
      Object obj = map.get("extra_delivery_list");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtraDeliveryList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("free_sf")) {
      Object obj = map.get("free_sf");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setFreeSf((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFreeSf(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("gift_delivery_list")) {
      Object obj = map.get("gift_delivery_list");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGiftDeliveryList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gift_list")) {
      Object obj = map.get("gift_list");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGiftList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_amount")) {
      Object obj = map.get("goods_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setGoodsAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setGoodsAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setGoodsAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGoodsAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setGoodsAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("group_order_id")) {
      Object obj = map.get("group_order_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGroupOrderId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGroupOrderId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setGroupOrderId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("home_install_value")) {
      Object obj = map.get("home_install_value");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setHomeInstallValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setHomeInstallValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setHomeInstallValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setHomeInstallValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setHomeInstallValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoice_status")) {
      Object obj = map.get("invoice_status");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setInvoiceStatus((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceStatus(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("is_lucky_flag")) {
      Object obj = map.get("is_lucky_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsLuckyFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_pre_sale")) {
      Object obj = map.get("is_pre_sale");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsPreSale((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsPreSale(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("is_stock_out")) {
      Object obj = map.get("is_stock_out");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setIsStockOut((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setIsStockOut(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("last_ship_time")) {
      Object obj = map.get("last_ship_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLastShipTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistics_id")) {
      Object obj = map.get("logistics_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLogisticsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLogisticsId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setLogisticsId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("only_support_replace")) {
      Object obj = map.get("only_support_replace");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setOnlySupportReplace((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOnlySupportReplace(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("open_address_id")) {
      Object obj = map.get("open_address_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOpenAddressId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_change_amount")) {
      Object obj = map.get("order_change_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrderChangeAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrderChangeAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrderChangeAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderChangeAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderChangeAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("order_sn")) {
      Object obj = map.get("order_sn");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderSn((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_status")) {
      Object obj = map.get("order_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("pay_no")) {
      Object obj = map.get("pay_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_time")) {
      Object obj = map.get("pay_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("platform_discount")) {
      Object obj = map.get("platform_discount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPlatformDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPlatformDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPlatformDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPlatformDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPlatformDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("postage")) {
      Object obj = map.get("postage");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPostage((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPostage(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPostage(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPostage(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPostage(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("pre_sale_time")) {
      Object obj = map.get("pre_sale_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreSaleTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("province")) {
      Object obj = map.get("province");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProvince((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("province_id")) {
      Object obj = map.get("province_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setProvinceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setProvinceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setProvinceId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("receive_time")) {
      Object obj = map.get("receive_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiver_address")) {
      Object obj = map.get("receiver_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiverAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiver_address_mask")) {
      Object obj = map.get("receiver_address_mask");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiverAddressMask((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiver_phone")) {
      Object obj = map.get("receiver_phone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiverPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiver_phone_mask")) {
      Object obj = map.get("receiver_phone_mask");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiverPhoneMask((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_status")) {
      Object obj = map.get("refund_status");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRefundStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRefundStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setRefundStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("risk_control_status")) {
      Object obj = map.get("risk_control_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRiskControlStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("self_contained")) {
      Object obj = map.get("self_contained");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setSelfContained((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSelfContained(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("seller_discount")) {
      Object obj = map.get("seller_discount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSellerDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSellerDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSellerDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSellerDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("service_fee_detail")) {
      Object obj = map.get("service_fee_detail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setServiceFeeDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ship_additional_link_order")) {
      Object obj = map.get("ship_additional_link_order");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipAdditionalLinkOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ship_additional_origin_order")) {
      Object obj = map.get("ship_additional_origin_order");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipAdditionalOriginOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipping_time")) {
      Object obj = map.get("shipping_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShippingTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipping_type")) {
      Object obj = map.get("shipping_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShippingType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("step_order_info")) {
      Object obj = map.get("step_order_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStepOrderInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("stock_out_handle_status")) {
      Object obj = map.get("stock_out_handle_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStockOutHandleStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("support_nationwide_warranty")) {
      Object obj = map.get("support_nationwide_warranty");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setSupportNationwideWarranty((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSupportNationwideWarranty(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("town")) {
      Object obj = map.get("town");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTown((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("town_id")) {
      Object obj = map.get("town_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTownId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTownId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTownId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tracking_number")) {
      Object obj = map.get("tracking_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTrackingNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trade_type")) {
      Object obj = map.get("trade_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTradeType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("updated_at")) {
      Object obj = map.get("updated_at");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdatedAt((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("urge_shipping_time")) {
      Object obj = map.get("urge_shipping_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUrgeShippingTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("yyps_date")) {
      Object obj = map.get("yyps_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYypsDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("yyps_time")) {
      Object obj = map.get("yyps_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYypsTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gmt_create")) {
      Object obj = map.get("gmt_create");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGmtCreate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGmtCreate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGmtCreate(null);
      }
    }
    if(map.containsKey("order_tag_list")) {
      Object obj = map.get("order_tag_list");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderTagList((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBussinessUnitName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_type")) {
      Object obj = map.get("pay_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mkt_biz_type")) {
      Object obj = map.get("mkt_biz_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMktBizType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("home_delivery_type")) {
      Object obj = map.get("home_delivery_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHomeDeliveryType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("group_status")) {
      Object obj = map.get("group_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGroupStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("group_role")) {
      Object obj = map.get("group_role");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGroupRole((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("confirm_status")) {
      Object obj = map.get("confirm_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfirmStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
