package com.xforceplus.policymanagement.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-12-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TbAfterSale implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 店铺编号
   */
  private String storeId;

  /**
   * 退款申请时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime refundApplyTime;

  /**
   * 获取账单日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime acqBillDate;

  /**
   * 租户code
   */
  private String tbTenantCode;

  /**
   * 订单编号
   */
  private String orderNo;

  /**
   * 退款编号
   */
  private String refundOrderNo;

  /**
   * 支付单号
   */
  private String payOrderNo;

  /**
   * 订单付款时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderPayTime;

  /**
   * 商品编码
   */
  private String goodsNo;

  /**
   * 退款完结时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime refundFinishTime;

  /**
   * 买家实付金额
   */
  private BigDecimal buyerRealPay;

  /**
   * 宝贝标题
   */
  private String treasureTitle;

  /**
   * 买家退款金额
   */
  private BigDecimal buyerRefundAmount;

  /**
   * 手工退款/系统退款
   */
  private String manualSysRefund;

  /**
   * 是否需要退货
   */
  private String returnProductFlag;

  /**
   * 超时时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime timeoutTime;

  /**
   * 退款状态
   */
  private String refundStatus;

  /**
   * 货物状态
   */
  private String goodsStatus;

  /**
   * 退货物流信息
   */
  private String returnLogistics;

  /**
   * 发货物流信息
   */
  private String deliverLogistics;

  /**
   * 客服介入状态
   */
  private String customerServiceIn;

  /**
   * 卖家真实姓名
   */
  private String sellerRealName;

  /**
   * 卖家真实姓名(新)
   */
  private String sellerRealNameNew;

  /**
   * 卖家退货地址
   */
  private String sellerReturnsAddress;

  /**
   * 卖家邮编
   */
  private String sellerPostCode;

  /**
   * 卖家电话
   */
  private String sellerTelephone;

  /**
   * 卖家手机
   */
  private String sellerMobile;

  /**
   * 退货物流单号
   */
  private String returnLogisticsNo;

  /**
   * 退货物流公司
   */
  private String returnLogisticsCompany;

  /**
   * 买家退款原因
   */
  private String buyerRefundReason;

  /**
   * 买家退款说明
   */
  private String buyerRefundRemark;

  /**
   * 买家退货时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime buyerReturnsTime;

  /**
   * 责任方
   */
  private String responsibleParty;

  /**
   * 售中或售后
   */
  private String inAfterSale;

  /**
   * 备注标签
   */
  private String remarkTag;

  /**
   * 商家备注
   */
  private String merchantRemark;

  /**
   * 部分退款/全额退款
   */
  private String parAllRefund;

  /**
   * 审核操作人
   */
  private String operateAuditor;

  /**
   * 审核操作人新会员名
   */
  private String operateAuditorNewName;

  /**
   * 举证超时
   */
  private String proofTimeout;

  /**
   * 是否零秒响应
   */
  private String zeroResponse;

  /**
   * 退款操作人
   */
  private String operatorRefund;

  /**
   * 退款操作人新会员名
   */
  private String operateRefundNewName;

  /**
   * 退款原因标签
   */
  private String refundReasonTag;

  /**
   * 业务类型
   */
  private String businessType;

  /**
   * 是否帮他退款
   */
  private String refundHelp;

  /**
   * 帮他退款操作账号
   */
  private String refundHelpAccount;

  /**
   * 小额收款
   */
  private String smallAmountRev;

  /**
   * 淘特订单
   */
  private String taoTeOrder;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 单据流转处理状态
   */
  private String dealStatus;

  /**
   * 业务ID
   */
  private String businessId;

  /**
   * 对账状态
   */
  @TableField("checkStatus")
  private String checkStatus;

  /**
   * 数据MD5
   */
  @TableField("dataMD5")
  private String dataMD5;

  /**
   * 异常信息
   */
  private String errorMsg;

  /**
   * 淘宝ID
   */
  private Long tbId;

  /**
   * 完结时间
   */
  private String finishTime;

  /**
   * 对账金额
   */
  private BigDecimal checkAmount;

  /**
   * 店铺名称
   */
  private String shopName;

  /**
   * 事业部名称
   */
  private String bussinessUnitName;

  /**
   * 公司名称
   */
  private String companyName;

  /**
   * 公司税号
   */
  private String companyTaxNo;

  /**
   * 最新版本
   */
  private Boolean latest;

  /**
   * 账期
   */
  private String accountPeriod;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("store_id", storeId);
      map.put("refund_apply_time", BocpGenUtils.toTimestamp(refundApplyTime));
      map.put("acq_bill_date", BocpGenUtils.toTimestamp(acqBillDate));
      map.put("tb_tenant_code", tbTenantCode);
      map.put("order_no", orderNo);
      map.put("refund_order_no", refundOrderNo);
      map.put("pay_order_no", payOrderNo);
      map.put("order_pay_time", BocpGenUtils.toTimestamp(orderPayTime));
      map.put("goods_no", goodsNo);
      map.put("refund_finish_time", BocpGenUtils.toTimestamp(refundFinishTime));
      map.put("buyer_real_pay", buyerRealPay);
      map.put("treasure_title", treasureTitle);
      map.put("buyer_refund_amount", buyerRefundAmount);
      map.put("manual_sys_refund", manualSysRefund);
      map.put("return_product_flag", returnProductFlag);
      map.put("timeout_time", BocpGenUtils.toTimestamp(timeoutTime));
      map.put("refund_status", refundStatus);
      map.put("goods_status", goodsStatus);
      map.put("return_logistics", returnLogistics);
      map.put("deliver_logistics", deliverLogistics);
      map.put("customer_service_in", customerServiceIn);
      map.put("seller_real_name", sellerRealName);
      map.put("seller_real_name_new", sellerRealNameNew);
      map.put("seller_returns_address", sellerReturnsAddress);
      map.put("seller_post_code", sellerPostCode);
      map.put("seller_telephone", sellerTelephone);
      map.put("seller_mobile", sellerMobile);
      map.put("return_logistics_no", returnLogisticsNo);
      map.put("return_logistics_company", returnLogisticsCompany);
      map.put("buyer_refund_reason", buyerRefundReason);
      map.put("buyer_refund_remark", buyerRefundRemark);
      map.put("buyer_returns_time", BocpGenUtils.toTimestamp(buyerReturnsTime));
      map.put("responsible_party", responsibleParty);
      map.put("in_after_sale", inAfterSale);
      map.put("remark_tag", remarkTag);
      map.put("merchant_remark", merchantRemark);
      map.put("par_all_refund", parAllRefund);
      map.put("operate_auditor", operateAuditor);
      map.put("operate_auditor_new_name", operateAuditorNewName);
      map.put("proof_timeout", proofTimeout);
      map.put("zero_response", zeroResponse);
      map.put("operator_refund", operatorRefund);
      map.put("operate_refund_new_name", operateRefundNewName);
      map.put("refund_reason_tag", refundReasonTag);
      map.put("business_type", businessType);
      map.put("refund_help", refundHelp);
      map.put("refund_help_account", refundHelpAccount);
      map.put("small_amount_rev", smallAmountRev);
      map.put("tao_te_order", taoTeOrder);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("deal_status", dealStatus);
      map.put("business_id", businessId);
      map.put("checkStatus", checkStatus);
      map.put("dataMD5", dataMD5);
      map.put("error_msg", errorMsg);
      map.put("tb_id", tbId);
      map.put("finish_time", finishTime);
      map.put("check_amount", checkAmount);
      map.put("shop_name", shopName);
      map.put("bussiness_unit_name", bussinessUnitName);
      map.put("company_name", companyName);
      map.put("company_tax_no", companyTaxNo);
      map.put("latest", latest);
      map.put("account_period", accountPeriod);
      map.put("org_tree", orgTree);

      return map;
  }

  public static TbAfterSale fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TbAfterSale entity = new TbAfterSale();
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_apply_time")) {
      Object obj = map.get("refund_apply_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRefundApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRefundApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRefundApplyTime(null);
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAcqBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAcqBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAcqBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAcqBillDate(null);
      }
    }
    if(map.containsKey("tb_tenant_code")) {
      Object obj = map.get("tb_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTbTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_order_no")) {
      Object obj = map.get("refund_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_order_no")) {
      Object obj = map.get("pay_order_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("order_pay_time")) {
      Object obj = map.get("order_pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOrderPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderPayTime(null);
      }
    }
    if(map.containsKey("goods_no")) {
      Object obj = map.get("goods_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_finish_time")) {
      Object obj = map.get("refund_finish_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRefundFinishTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRefundFinishTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRefundFinishTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRefundFinishTime(null);
      }
    }
    if(map.containsKey("buyer_real_pay")) {
      Object obj = map.get("buyer_real_pay");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBuyerRealPay((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBuyerRealPay(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBuyerRealPay(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBuyerRealPay(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBuyerRealPay(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("treasure_title")) {
      Object obj = map.get("treasure_title");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTreasureTitle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_refund_amount")) {
      Object obj = map.get("buyer_refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBuyerRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBuyerRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBuyerRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBuyerRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBuyerRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("manual_sys_refund")) {
      Object obj = map.get("manual_sys_refund");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setManualSysRefund((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_product_flag")) {
      Object obj = map.get("return_product_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnProductFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("timeout_time")) {
      Object obj = map.get("timeout_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTimeoutTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTimeoutTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTimeoutTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTimeoutTime(null);
      }
    }
    if(map.containsKey("refund_status")) {
      Object obj = map.get("refund_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goods_status")) {
      Object obj = map.get("goods_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_logistics")) {
      Object obj = map.get("return_logistics");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnLogistics((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliver_logistics")) {
      Object obj = map.get("deliver_logistics");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliverLogistics((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customer_service_in")) {
      Object obj = map.get("customer_service_in");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerServiceIn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_real_name")) {
      Object obj = map.get("seller_real_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerRealName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_real_name_new")) {
      Object obj = map.get("seller_real_name_new");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerRealNameNew((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_returns_address")) {
      Object obj = map.get("seller_returns_address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerReturnsAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_post_code")) {
      Object obj = map.get("seller_post_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerPostCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_telephone")) {
      Object obj = map.get("seller_telephone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTelephone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_mobile")) {
      Object obj = map.get("seller_mobile");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerMobile((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_logistics_no")) {
      Object obj = map.get("return_logistics_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnLogisticsNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("return_logistics_company")) {
      Object obj = map.get("return_logistics_company");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnLogisticsCompany((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_refund_reason")) {
      Object obj = map.get("buyer_refund_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerRefundReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_refund_remark")) {
      Object obj = map.get("buyer_refund_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyerRefundRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer_returns_time")) {
      Object obj = map.get("buyer_returns_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBuyerReturnsTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBuyerReturnsTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBuyerReturnsTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBuyerReturnsTime(null);
      }
    }
    if(map.containsKey("responsible_party")) {
      Object obj = map.get("responsible_party");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setResponsibleParty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("in_after_sale")) {
      Object obj = map.get("in_after_sale");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInAfterSale((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark_tag")) {
      Object obj = map.get("remark_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemarkTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("merchant_remark")) {
      Object obj = map.get("merchant_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMerchantRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("par_all_refund")) {
      Object obj = map.get("par_all_refund");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setParAllRefund((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operate_auditor")) {
      Object obj = map.get("operate_auditor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOperateAuditor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operate_auditor_new_name")) {
      Object obj = map.get("operate_auditor_new_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOperateAuditorNewName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("proof_timeout")) {
      Object obj = map.get("proof_timeout");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProofTimeout((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zero_response")) {
      Object obj = map.get("zero_response");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZeroResponse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operator_refund")) {
      Object obj = map.get("operator_refund");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOperatorRefund((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operate_refund_new_name")) {
      Object obj = map.get("operate_refund_new_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOperateRefundNewName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_reason_tag")) {
      Object obj = map.get("refund_reason_tag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundReasonTag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_help")) {
      Object obj = map.get("refund_help");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundHelp((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund_help_account")) {
      Object obj = map.get("refund_help_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefundHelpAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("small_amount_rev")) {
      Object obj = map.get("small_amount_rev");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSmallAmountRev((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tao_te_order")) {
      Object obj = map.get("tao_te_order");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaoTeOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDealStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMsg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tb_id")) {
      Object obj = map.get("tb_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTbId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTbId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTbId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("finish_time")) {
      Object obj = map.get("finish_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFinishTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShopName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBussinessUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccountPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("store_id")) {
      Object obj = map.get("store_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_apply_time")) {
      Object obj = map.get("refund_apply_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRefundApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRefundApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRefundApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRefundApplyTime(null);
      }
    }
    if(map.containsKey("acq_bill_date")) {
      Object obj = map.get("acq_bill_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAcqBillDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAcqBillDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAcqBillDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAcqBillDate(null);
      }
    }
    if(map.containsKey("tb_tenant_code")) {
      Object obj = map.get("tb_tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTbTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_no")) {
      Object obj = map.get("order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_order_no")) {
      Object obj = map.get("refund_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_order_no")) {
      Object obj = map.get("pay_order_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("order_pay_time")) {
      Object obj = map.get("order_pay_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderPayTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOrderPayTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderPayTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOrderPayTime(null);
      }
    }
    if(map.containsKey("goods_no")) {
      Object obj = map.get("goods_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_finish_time")) {
      Object obj = map.get("refund_finish_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRefundFinishTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRefundFinishTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRefundFinishTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRefundFinishTime(null);
      }
    }
    if(map.containsKey("buyer_real_pay")) {
      Object obj = map.get("buyer_real_pay");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBuyerRealPay((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBuyerRealPay(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBuyerRealPay(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBuyerRealPay(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBuyerRealPay(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("treasure_title")) {
      Object obj = map.get("treasure_title");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTreasureTitle((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_refund_amount")) {
      Object obj = map.get("buyer_refund_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBuyerRefundAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBuyerRefundAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBuyerRefundAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBuyerRefundAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBuyerRefundAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("manual_sys_refund")) {
      Object obj = map.get("manual_sys_refund");
      if(obj != null) {
        if(obj instanceof String) {
          this.setManualSysRefund((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("return_product_flag")) {
      Object obj = map.get("return_product_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnProductFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("timeout_time")) {
      Object obj = map.get("timeout_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTimeoutTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTimeoutTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTimeoutTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTimeoutTime(null);
      }
    }
    if(map.containsKey("refund_status")) {
      Object obj = map.get("refund_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goods_status")) {
      Object obj = map.get("goods_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("return_logistics")) {
      Object obj = map.get("return_logistics");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnLogistics((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliver_logistics")) {
      Object obj = map.get("deliver_logistics");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliverLogistics((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customer_service_in")) {
      Object obj = map.get("customer_service_in");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerServiceIn((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_real_name")) {
      Object obj = map.get("seller_real_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerRealName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_real_name_new")) {
      Object obj = map.get("seller_real_name_new");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerRealNameNew((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_returns_address")) {
      Object obj = map.get("seller_returns_address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerReturnsAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_post_code")) {
      Object obj = map.get("seller_post_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerPostCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_telephone")) {
      Object obj = map.get("seller_telephone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTelephone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_mobile")) {
      Object obj = map.get("seller_mobile");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerMobile((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("return_logistics_no")) {
      Object obj = map.get("return_logistics_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnLogisticsNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("return_logistics_company")) {
      Object obj = map.get("return_logistics_company");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnLogisticsCompany((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_refund_reason")) {
      Object obj = map.get("buyer_refund_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerRefundReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_refund_remark")) {
      Object obj = map.get("buyer_refund_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyerRefundRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer_returns_time")) {
      Object obj = map.get("buyer_returns_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBuyerReturnsTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBuyerReturnsTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBuyerReturnsTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBuyerReturnsTime(null);
      }
    }
    if(map.containsKey("responsible_party")) {
      Object obj = map.get("responsible_party");
      if(obj != null) {
        if(obj instanceof String) {
          this.setResponsibleParty((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("in_after_sale")) {
      Object obj = map.get("in_after_sale");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInAfterSale((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark_tag")) {
      Object obj = map.get("remark_tag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemarkTag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("merchant_remark")) {
      Object obj = map.get("merchant_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMerchantRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("par_all_refund")) {
      Object obj = map.get("par_all_refund");
      if(obj != null) {
        if(obj instanceof String) {
          this.setParAllRefund((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("operate_auditor")) {
      Object obj = map.get("operate_auditor");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOperateAuditor((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("operate_auditor_new_name")) {
      Object obj = map.get("operate_auditor_new_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOperateAuditorNewName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("proof_timeout")) {
      Object obj = map.get("proof_timeout");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProofTimeout((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zero_response")) {
      Object obj = map.get("zero_response");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZeroResponse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("operator_refund")) {
      Object obj = map.get("operator_refund");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOperatorRefund((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("operate_refund_new_name")) {
      Object obj = map.get("operate_refund_new_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOperateRefundNewName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_reason_tag")) {
      Object obj = map.get("refund_reason_tag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundReasonTag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_help")) {
      Object obj = map.get("refund_help");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundHelp((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund_help_account")) {
      Object obj = map.get("refund_help_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefundHelpAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("small_amount_rev")) {
      Object obj = map.get("small_amount_rev");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSmallAmountRev((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tao_te_order")) {
      Object obj = map.get("tao_te_order");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaoTeOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deal_status")) {
      Object obj = map.get("deal_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDealStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_id")) {
      Object obj = map.get("business_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("error_msg")) {
      Object obj = map.get("error_msg");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMsg((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tb_id")) {
      Object obj = map.get("tb_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTbId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTbId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTbId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("finish_time")) {
      Object obj = map.get("finish_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFinishTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("check_amount")) {
      Object obj = map.get("check_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCheckAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCheckAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCheckAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCheckAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCheckAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("shop_name")) {
      Object obj = map.get("shop_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShopName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bussiness_unit_name")) {
      Object obj = map.get("bussiness_unit_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBussinessUnitName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_name")) {
      Object obj = map.get("company_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("company_tax_no")) {
      Object obj = map.get("company_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("account_period")) {
      Object obj = map.get("account_period");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccountPeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
