package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.DyCheck;
import com.xforceplus.policymanagement.service.IDyCheckService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 抖音账单前端控制器
 *
 * @author ultraman
 * @date 2024-10-31
 */
@RestController
public class DyCheckController {

  @Autowired
  private IDyCheckService dyCheckServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dyCheck 抖音账单
   * @return
   */
  @GetMapping("/dychecks" )
  public XfR getDyChecks(XfPage page, DyCheck dyCheck) {
    return XfR.ok(dyCheckServiceImpl.page(page, Wrappers.query(dyCheck)));
  }

  /**
   * 通过id查询抖音账单
   * @param  id
   * @return XfR
   */
  @GetMapping("/dychecks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(dyCheckServiceImpl.getById(id));
  }

  /**
   * 新增抖音账单
   * @param dyCheck 抖音账单
   * @return XfR
   */
  @PostMapping("/dychecks")
  public XfR save(@RequestBody DyCheck dyCheck) {
     return XfR.ok(dyCheckServiceImpl.save(dyCheck));
  }

  /**
   * 修改-传入修改后的全部数据抖音账单
   * @param dyCheck 抖音账单
   * @return XfR
   */
  @PutMapping("/dychecks/{id}")
  public XfR putUpdate(@RequestBody DyCheck dyCheck,@PathVariable Long id) {
      dyCheck.setId(id);
      return XfR.ok(dyCheckServiceImpl.updateById(dyCheck));
  }

  /**
   * 修改-传入修改的数据抖音账单
   * @param dyCheck 抖音账单
   * @return XfR
   */
  @PatchMapping("/dychecks/{id}")
  public XfR patchUpdate(@RequestBody DyCheck dyCheck,@PathVariable Long id) {
      DyCheck updyCheck = dyCheckServiceImpl.getById(id);
      if(updyCheck != null){
        updyCheck = ObjectCopyUtils.copyProperties(dyCheck,updyCheck,true);
      }
      return XfR.ok(dyCheckServiceImpl.updateById(updyCheck));
  }

  /**
   * 通过id删除抖音账单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dychecks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(dyCheckServiceImpl.removeById(id));
  }

  @PostMapping("/dychecks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "dy_check");
     params.put("request", condition);

     return XfR.ok(dyCheckServiceImpl.querys(params));
  }

}
