package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.OmsOrder;
import com.xforceplus.policymanagement.service.IOmsOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-31
 */
@RestController
public class OmsOrderController {

  @Autowired
  private IOmsOrderService omsOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param omsOrder ${table.comment}
   * @return
   */
  @GetMapping("/omsorders" )
  public XfR getOmsOrders(XfPage page, OmsOrder omsOrder) {
    return XfR.ok(omsOrderServiceImpl.page(page, Wrappers.query(omsOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/omsorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(omsOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param omsOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/omsorders")
  public XfR save(@RequestBody OmsOrder omsOrder) {
     return XfR.ok(omsOrderServiceImpl.save(omsOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param omsOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/omsorders/{id}")
  public XfR putUpdate(@RequestBody OmsOrder omsOrder,@PathVariable Long id) {
      omsOrder.setId(id);
      return XfR.ok(omsOrderServiceImpl.updateById(omsOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param omsOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/omsorders/{id}")
  public XfR patchUpdate(@RequestBody OmsOrder omsOrder,@PathVariable Long id) {
      OmsOrder upomsOrder = omsOrderServiceImpl.getById(id);
      if(upomsOrder != null){
        upomsOrder = ObjectCopyUtils.copyProperties(omsOrder,upomsOrder,true);
      }
      return XfR.ok(omsOrderServiceImpl.updateById(upomsOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/omsorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(omsOrderServiceImpl.removeById(id));
  }

  @PostMapping("/omsorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oms_order");
     params.put("request", condition);

     return XfR.ok(omsOrderServiceImpl.querys(params));
  }

}
