package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.OmsOrderDetail;
import com.xforceplus.policymanagement.service.IOmsOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-31
 */
@RestController
public class OmsOrderDetailController {

  @Autowired
  private IOmsOrderDetailService omsOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param omsOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/omsorderdetails" )
  public XfR getOmsOrderDetails(XfPage page, OmsOrderDetail omsOrderDetail) {
    return XfR.ok(omsOrderDetailServiceImpl.page(page, Wrappers.query(omsOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/omsorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(omsOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param omsOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/omsorderdetails")
  public XfR save(@RequestBody OmsOrderDetail omsOrderDetail) {
     return XfR.ok(omsOrderDetailServiceImpl.save(omsOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param omsOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/omsorderdetails/{id}")
  public XfR putUpdate(@RequestBody OmsOrderDetail omsOrderDetail,@PathVariable Long id) {
      omsOrderDetail.setId(id);
      return XfR.ok(omsOrderDetailServiceImpl.updateById(omsOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param omsOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/omsorderdetails/{id}")
  public XfR patchUpdate(@RequestBody OmsOrderDetail omsOrderDetail,@PathVariable Long id) {
      OmsOrderDetail upomsOrderDetail = omsOrderDetailServiceImpl.getById(id);
      if(upomsOrderDetail != null){
        upomsOrderDetail = ObjectCopyUtils.copyProperties(omsOrderDetail,upomsOrderDetail,true);
      }
      return XfR.ok(omsOrderDetailServiceImpl.updateById(upomsOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/omsorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(omsOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/omsorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "oms_order_detail");
     params.put("request", condition);

     return XfR.ok(omsOrderDetailServiceImpl.querys(params));
  }

}
