package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.PolicyManagementDetail;
import com.xforceplus.policymanagement.service.IPolicyManagementDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-11
 */
@RestController
public class PolicyManagementDetailController {

  @Autowired
  private IPolicyManagementDetailService policyManagementDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param policyManagementDetail ${table.comment}
   * @return
   */
  @GetMapping("/policymanagementdetails" )
  public XfR getPolicyManagementDetails(XfPage page, PolicyManagementDetail policyManagementDetail) {
    return XfR.ok(policyManagementDetailServiceImpl.page(page, Wrappers.query(policyManagementDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/policymanagementdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(policyManagementDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param policyManagementDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/policymanagementdetails")
  public XfR save(@RequestBody PolicyManagementDetail policyManagementDetail) {
     return XfR.ok(policyManagementDetailServiceImpl.save(policyManagementDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param policyManagementDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/policymanagementdetails/{id}")
  public XfR putUpdate(@RequestBody PolicyManagementDetail policyManagementDetail,@PathVariable Long id) {
      policyManagementDetail.setId(id);
      return XfR.ok(policyManagementDetailServiceImpl.updateById(policyManagementDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param policyManagementDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/policymanagementdetails/{id}")
  public XfR patchUpdate(@RequestBody PolicyManagementDetail policyManagementDetail,@PathVariable Long id) {
      PolicyManagementDetail uppolicyManagementDetail = policyManagementDetailServiceImpl.getById(id);
      if(uppolicyManagementDetail != null){
        uppolicyManagementDetail = ObjectCopyUtils.copyProperties(policyManagementDetail,uppolicyManagementDetail,true);
      }
      return XfR.ok(policyManagementDetailServiceImpl.updateById(uppolicyManagementDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/policymanagementdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(policyManagementDetailServiceImpl.removeById(id));
  }

  @PostMapping("/policymanagementdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "policy_management_detail");
     params.put("request", condition);

     return XfR.ok(policyManagementDetailServiceImpl.querys(params));
  }

}
