package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.JdSalesOrder;
import com.xforceplus.policymanagement.service.IJdSalesOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-23
 */
@RestController
public class JdSalesOrderController {

  @Autowired
  private IJdSalesOrderService jdSalesOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param jdSalesOrder ${table.comment}
   * @return
   */
  @GetMapping("/jdsalesorders" )
  public XfR getJdSalesOrders(XfPage page, JdSalesOrder jdSalesOrder) {
    return XfR.ok(jdSalesOrderServiceImpl.page(page, Wrappers.query(jdSalesOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/jdsalesorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(jdSalesOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param jdSalesOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/jdsalesorders")
  public XfR save(@RequestBody JdSalesOrder jdSalesOrder) {
     return XfR.ok(jdSalesOrderServiceImpl.save(jdSalesOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param jdSalesOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/jdsalesorders/{id}")
  public XfR putUpdate(@RequestBody JdSalesOrder jdSalesOrder,@PathVariable Long id) {
      jdSalesOrder.setId(id);
      return XfR.ok(jdSalesOrderServiceImpl.updateById(jdSalesOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param jdSalesOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/jdsalesorders/{id}")
  public XfR patchUpdate(@RequestBody JdSalesOrder jdSalesOrder,@PathVariable Long id) {
      JdSalesOrder upjdSalesOrder = jdSalesOrderServiceImpl.getById(id);
      if(upjdSalesOrder != null){
        upjdSalesOrder = ObjectCopyUtils.copyProperties(jdSalesOrder,upjdSalesOrder,true);
      }
      return XfR.ok(jdSalesOrderServiceImpl.updateById(upjdSalesOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/jdsalesorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(jdSalesOrderServiceImpl.removeById(id));
  }

  @PostMapping("/jdsalesorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "jd_sales_order");
     params.put("request", condition);

     return XfR.ok(jdSalesOrderServiceImpl.querys(params));
  }

}
