package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.TbAfterSale;
import com.xforceplus.policymanagement.service.ITbAfterSaleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-15
 */
@RestController
public class TbAfterSaleController {

  @Autowired
  private ITbAfterSaleService tbAfterSaleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tbAfterSale ${table.comment}
   * @return
   */
  @GetMapping("/tbaftersales" )
  public XfR getTbAfterSales(XfPage page, TbAfterSale tbAfterSale) {
    return XfR.ok(tbAfterSaleServiceImpl.page(page, Wrappers.query(tbAfterSale)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tbaftersales/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tbAfterSaleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tbAfterSale ${table.comment}
   * @return XfR
   */
  @PostMapping("/tbaftersales")
  public XfR save(@RequestBody TbAfterSale tbAfterSale) {
     return XfR.ok(tbAfterSaleServiceImpl.save(tbAfterSale));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tbAfterSale ${table.comment}
   * @return XfR
   */
  @PutMapping("/tbaftersales/{id}")
  public XfR putUpdate(@RequestBody TbAfterSale tbAfterSale,@PathVariable Long id) {
      tbAfterSale.setId(id);
      return XfR.ok(tbAfterSaleServiceImpl.updateById(tbAfterSale));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tbAfterSale ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tbaftersales/{id}")
  public XfR patchUpdate(@RequestBody TbAfterSale tbAfterSale,@PathVariable Long id) {
      TbAfterSale uptbAfterSale = tbAfterSaleServiceImpl.getById(id);
      if(uptbAfterSale != null){
        uptbAfterSale = ObjectCopyUtils.copyProperties(tbAfterSale,uptbAfterSale,true);
      }
      return XfR.ok(tbAfterSaleServiceImpl.updateById(uptbAfterSale));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tbaftersales/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tbAfterSaleServiceImpl.removeById(id));
  }

  @PostMapping("/tbaftersales/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tb_after_sale");
     params.put("request", condition);

     return XfR.ok(tbAfterSaleServiceImpl.querys(params));
  }

}
