package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.CheckConfig;
import com.xforceplus.policymanagement.service.ICheckConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 对账配置前端控制器
 *
 * @author ultraman
 * @date 2024-11-18
 */
@RestController
public class CheckConfigController {

  @Autowired
  private ICheckConfigService checkConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param checkConfig 对账配置
   * @return
   */
  @GetMapping("/checkconfigs" )
  public XfR getCheckConfigs(XfPage page, CheckConfig checkConfig) {
    return XfR.ok(checkConfigServiceImpl.page(page, Wrappers.query(checkConfig)));
  }

  /**
   * 通过id查询对账配置
   * @param  id
   * @return XfR
   */
  @GetMapping("/checkconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(checkConfigServiceImpl.getById(id));
  }

  /**
   * 新增对账配置
   * @param checkConfig 对账配置
   * @return XfR
   */
  @PostMapping("/checkconfigs")
  public XfR save(@RequestBody CheckConfig checkConfig) {
     return XfR.ok(checkConfigServiceImpl.save(checkConfig));
  }

  /**
   * 修改-传入修改后的全部数据对账配置
   * @param checkConfig 对账配置
   * @return XfR
   */
  @PutMapping("/checkconfigs/{id}")
  public XfR putUpdate(@RequestBody CheckConfig checkConfig,@PathVariable Long id) {
      checkConfig.setId(id);
      return XfR.ok(checkConfigServiceImpl.updateById(checkConfig));
  }

  /**
   * 修改-传入修改的数据对账配置
   * @param checkConfig 对账配置
   * @return XfR
   */
  @PatchMapping("/checkconfigs/{id}")
  public XfR patchUpdate(@RequestBody CheckConfig checkConfig,@PathVariable Long id) {
      CheckConfig upcheckConfig = checkConfigServiceImpl.getById(id);
      if(upcheckConfig != null){
        upcheckConfig = ObjectCopyUtils.copyProperties(checkConfig,upcheckConfig,true);
      }
      return XfR.ok(checkConfigServiceImpl.updateById(upcheckConfig));
  }

  /**
   * 通过id删除对账配置
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/checkconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(checkConfigServiceImpl.removeById(id));
  }

  @PostMapping("/checkconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "check_config");
     params.put("request", condition);

     return XfR.ok(checkConfigServiceImpl.querys(params));
  }

}
