package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.SystemRelRoleUser;
import com.xforceplus.policymanagement.service.ISystemRelRoleUserService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 人员角色关系系统对象前端控制器
 *
 * @author ultraman
 * @date 2024-11-18
 */
@RestController
public class SystemRelRoleUserController {

  @Autowired
  private ISystemRelRoleUserService systemRelRoleUserServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemRelRoleUser 人员角色关系系统对象
   * @return
   */
  @GetMapping("/systemrelroleusers" )
  public XfR getSystemRelRoleUsers(XfPage page, SystemRelRoleUser systemRelRoleUser) {
    return XfR.ok(systemRelRoleUserServiceImpl.page(page, Wrappers.query(systemRelRoleUser)));
  }

  /**
   * 通过id查询人员角色关系系统对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemrelroleusers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemRelRoleUserServiceImpl.getById(id));
  }

  /**
   * 新增人员角色关系系统对象
   * @param systemRelRoleUser 人员角色关系系统对象
   * @return XfR
   */
  @PostMapping("/systemrelroleusers")
  public XfR save(@RequestBody SystemRelRoleUser systemRelRoleUser) {
     return XfR.ok(systemRelRoleUserServiceImpl.save(systemRelRoleUser));
  }

  /**
   * 修改-传入修改后的全部数据人员角色关系系统对象
   * @param systemRelRoleUser 人员角色关系系统对象
   * @return XfR
   */
  @PutMapping("/systemrelroleusers/{id}")
  public XfR putUpdate(@RequestBody SystemRelRoleUser systemRelRoleUser,@PathVariable Long id) {
      systemRelRoleUser.setId(id);
      return XfR.ok(systemRelRoleUserServiceImpl.updateById(systemRelRoleUser));
  }

  /**
   * 修改-传入修改的数据人员角色关系系统对象
   * @param systemRelRoleUser 人员角色关系系统对象
   * @return XfR
   */
  @PatchMapping("/systemrelroleusers/{id}")
  public XfR patchUpdate(@RequestBody SystemRelRoleUser systemRelRoleUser,@PathVariable Long id) {
      SystemRelRoleUser upsystemRelRoleUser = systemRelRoleUserServiceImpl.getById(id);
      if(upsystemRelRoleUser != null){
        upsystemRelRoleUser = ObjectCopyUtils.copyProperties(systemRelRoleUser,upsystemRelRoleUser,true);
      }
      return XfR.ok(systemRelRoleUserServiceImpl.updateById(upsystemRelRoleUser));
  }

  /**
   * 通过id删除人员角色关系系统对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemrelroleusers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemRelRoleUserServiceImpl.removeById(id));
  }

  @PostMapping("/systemrelroleusers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_rel_role_user");
     params.put("request", condition);

     return XfR.ok(systemRelRoleUserServiceImpl.querys(params));
  }

}
