package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.KsSalesOrder;
import com.xforceplus.policymanagement.service.IKsSalesOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-18
 */
@RestController
public class KsSalesOrderController {

  @Autowired
  private IKsSalesOrderService ksSalesOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ksSalesOrder ${table.comment}
   * @return
   */
  @GetMapping("/kssalesorders" )
  public XfR getKsSalesOrders(XfPage page, KsSalesOrder ksSalesOrder) {
    return XfR.ok(ksSalesOrderServiceImpl.page(page, Wrappers.query(ksSalesOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/kssalesorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ksSalesOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ksSalesOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/kssalesorders")
  public XfR save(@RequestBody KsSalesOrder ksSalesOrder) {
     return XfR.ok(ksSalesOrderServiceImpl.save(ksSalesOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ksSalesOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/kssalesorders/{id}")
  public XfR putUpdate(@RequestBody KsSalesOrder ksSalesOrder,@PathVariable Long id) {
      ksSalesOrder.setId(id);
      return XfR.ok(ksSalesOrderServiceImpl.updateById(ksSalesOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ksSalesOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/kssalesorders/{id}")
  public XfR patchUpdate(@RequestBody KsSalesOrder ksSalesOrder,@PathVariable Long id) {
      KsSalesOrder upksSalesOrder = ksSalesOrderServiceImpl.getById(id);
      if(upksSalesOrder != null){
        upksSalesOrder = ObjectCopyUtils.copyProperties(ksSalesOrder,upksSalesOrder,true);
      }
      return XfR.ok(ksSalesOrderServiceImpl.updateById(upksSalesOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/kssalesorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ksSalesOrderServiceImpl.removeById(id));
  }

  @PostMapping("/kssalesorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ks_sales_order");
     params.put("request", condition);

     return XfR.ok(ksSalesOrderServiceImpl.querys(params));
  }

}
