package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.TbSalesOrder;
import com.xforceplus.policymanagement.service.ITbSalesOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-18
 */
@RestController
public class TbSalesOrderController {

  @Autowired
  private ITbSalesOrderService tbSalesOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tbSalesOrder ${table.comment}
   * @return
   */
  @GetMapping("/tbsalesorders" )
  public XfR getTbSalesOrders(XfPage page, TbSalesOrder tbSalesOrder) {
    return XfR.ok(tbSalesOrderServiceImpl.page(page, Wrappers.query(tbSalesOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tbsalesorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tbSalesOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tbSalesOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/tbsalesorders")
  public XfR save(@RequestBody TbSalesOrder tbSalesOrder) {
     return XfR.ok(tbSalesOrderServiceImpl.save(tbSalesOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tbSalesOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/tbsalesorders/{id}")
  public XfR putUpdate(@RequestBody TbSalesOrder tbSalesOrder,@PathVariable Long id) {
      tbSalesOrder.setId(id);
      return XfR.ok(tbSalesOrderServiceImpl.updateById(tbSalesOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tbSalesOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tbsalesorders/{id}")
  public XfR patchUpdate(@RequestBody TbSalesOrder tbSalesOrder,@PathVariable Long id) {
      TbSalesOrder uptbSalesOrder = tbSalesOrderServiceImpl.getById(id);
      if(uptbSalesOrder != null){
        uptbSalesOrder = ObjectCopyUtils.copyProperties(tbSalesOrder,uptbSalesOrder,true);
      }
      return XfR.ok(tbSalesOrderServiceImpl.updateById(uptbSalesOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tbsalesorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tbSalesOrderServiceImpl.removeById(id));
  }

  @PostMapping("/tbsalesorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tb_sales_order");
     params.put("request", condition);

     return XfR.ok(tbSalesOrderServiceImpl.querys(params));
  }

}
