package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.BillChangeRecord;
import com.xforceplus.policymanagement.service.IBillChangeRecordService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-20
 */
@RestController
public class BillChangeRecordController {

  @Autowired
  private IBillChangeRecordService billChangeRecordServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param billChangeRecord ${table.comment}
   * @return
   */
  @GetMapping("/billchangerecords" )
  public XfR getBillChangeRecords(XfPage page, BillChangeRecord billChangeRecord) {
    return XfR.ok(billChangeRecordServiceImpl.page(page, Wrappers.query(billChangeRecord)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/billchangerecords/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(billChangeRecordServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param billChangeRecord ${table.comment}
   * @return XfR
   */
  @PostMapping("/billchangerecords")
  public XfR save(@RequestBody BillChangeRecord billChangeRecord) {
     return XfR.ok(billChangeRecordServiceImpl.save(billChangeRecord));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param billChangeRecord ${table.comment}
   * @return XfR
   */
  @PutMapping("/billchangerecords/{id}")
  public XfR putUpdate(@RequestBody BillChangeRecord billChangeRecord,@PathVariable Long id) {
      billChangeRecord.setId(id);
      return XfR.ok(billChangeRecordServiceImpl.updateById(billChangeRecord));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param billChangeRecord ${table.comment}
   * @return XfR
   */
  @PatchMapping("/billchangerecords/{id}")
  public XfR patchUpdate(@RequestBody BillChangeRecord billChangeRecord,@PathVariable Long id) {
      BillChangeRecord upbillChangeRecord = billChangeRecordServiceImpl.getById(id);
      if(upbillChangeRecord != null){
        upbillChangeRecord = ObjectCopyUtils.copyProperties(billChangeRecord,upbillChangeRecord,true);
      }
      return XfR.ok(billChangeRecordServiceImpl.updateById(upbillChangeRecord));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/billchangerecords/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(billChangeRecordServiceImpl.removeById(id));
  }

  @PostMapping("/billchangerecords/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bill_change_record");
     params.put("request", condition);

     return XfR.ok(billChangeRecordServiceImpl.querys(params));
  }

}
