package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.SysFlowTaskHis;
import com.xforceplus.policymanagement.service.ISysFlowTaskHisService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统用户任务历史对象前端控制器
 *
 * @author ultraman
 * @date 2024-11-20
 */
@RestController
public class SysFlowTaskHisController {

  @Autowired
  private ISysFlowTaskHisService sysFlowTaskHisServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sysFlowTaskHis 系统用户任务历史对象
   * @return
   */
  @GetMapping("/sysflowtaskhiss" )
  public XfR getSysFlowTaskHiss(XfPage page, SysFlowTaskHis sysFlowTaskHis) {
    return XfR.ok(sysFlowTaskHisServiceImpl.page(page, Wrappers.query(sysFlowTaskHis)));
  }

  /**
   * 通过id查询系统用户任务历史对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/sysflowtaskhiss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sysFlowTaskHisServiceImpl.getById(id));
  }

  /**
   * 新增系统用户任务历史对象
   * @param sysFlowTaskHis 系统用户任务历史对象
   * @return XfR
   */
  @PostMapping("/sysflowtaskhiss")
  public XfR save(@RequestBody SysFlowTaskHis sysFlowTaskHis) {
     return XfR.ok(sysFlowTaskHisServiceImpl.save(sysFlowTaskHis));
  }

  /**
   * 修改-传入修改后的全部数据系统用户任务历史对象
   * @param sysFlowTaskHis 系统用户任务历史对象
   * @return XfR
   */
  @PutMapping("/sysflowtaskhiss/{id}")
  public XfR putUpdate(@RequestBody SysFlowTaskHis sysFlowTaskHis,@PathVariable Long id) {
      sysFlowTaskHis.setId(id);
      return XfR.ok(sysFlowTaskHisServiceImpl.updateById(sysFlowTaskHis));
  }

  /**
   * 修改-传入修改的数据系统用户任务历史对象
   * @param sysFlowTaskHis 系统用户任务历史对象
   * @return XfR
   */
  @PatchMapping("/sysflowtaskhiss/{id}")
  public XfR patchUpdate(@RequestBody SysFlowTaskHis sysFlowTaskHis,@PathVariable Long id) {
      SysFlowTaskHis upsysFlowTaskHis = sysFlowTaskHisServiceImpl.getById(id);
      if(upsysFlowTaskHis != null){
        upsysFlowTaskHis = ObjectCopyUtils.copyProperties(sysFlowTaskHis,upsysFlowTaskHis,true);
      }
      return XfR.ok(sysFlowTaskHisServiceImpl.updateById(upsysFlowTaskHis));
  }

  /**
   * 通过id删除系统用户任务历史对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sysflowtaskhiss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sysFlowTaskHisServiceImpl.removeById(id));
  }

  @PostMapping("/sysflowtaskhiss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sys_flow_task_his");
     params.put("request", condition);

     return XfR.ok(sysFlowTaskHisServiceImpl.querys(params));
  }

}
