package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.TbSalesOrderDetail;
import com.xforceplus.policymanagement.service.ITbSalesOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-20
 */
@RestController
public class TbSalesOrderDetailController {

  @Autowired
  private ITbSalesOrderDetailService tbSalesOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tbSalesOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/tbsalesorderdetails" )
  public XfR getTbSalesOrderDetails(XfPage page, TbSalesOrderDetail tbSalesOrderDetail) {
    return XfR.ok(tbSalesOrderDetailServiceImpl.page(page, Wrappers.query(tbSalesOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tbsalesorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tbSalesOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tbSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/tbsalesorderdetails")
  public XfR save(@RequestBody TbSalesOrderDetail tbSalesOrderDetail) {
     return XfR.ok(tbSalesOrderDetailServiceImpl.save(tbSalesOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tbSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/tbsalesorderdetails/{id}")
  public XfR putUpdate(@RequestBody TbSalesOrderDetail tbSalesOrderDetail,@PathVariable Long id) {
      tbSalesOrderDetail.setId(id);
      return XfR.ok(tbSalesOrderDetailServiceImpl.updateById(tbSalesOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tbSalesOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tbsalesorderdetails/{id}")
  public XfR patchUpdate(@RequestBody TbSalesOrderDetail tbSalesOrderDetail,@PathVariable Long id) {
      TbSalesOrderDetail uptbSalesOrderDetail = tbSalesOrderDetailServiceImpl.getById(id);
      if(uptbSalesOrderDetail != null){
        uptbSalesOrderDetail = ObjectCopyUtils.copyProperties(tbSalesOrderDetail,uptbSalesOrderDetail,true);
      }
      return XfR.ok(tbSalesOrderDetailServiceImpl.updateById(uptbSalesOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tbsalesorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tbSalesOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/tbsalesorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tb_sales_order_detail");
     params.put("request", condition);

     return XfR.ok(tbSalesOrderDetailServiceImpl.querys(params));
  }

}
