package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.DySalesOrder;
import com.xforceplus.policymanagement.service.IDySalesOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-26
 */
@RestController
public class DySalesOrderController {

  @Autowired
  private IDySalesOrderService dySalesOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param dySalesOrder ${table.comment}
   * @return
   */
  @GetMapping("/dysalesorders" )
  public XfR getDySalesOrders(XfPage page, DySalesOrder dySalesOrder) {
    return XfR.ok(dySalesOrderServiceImpl.page(page, Wrappers.query(dySalesOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/dysalesorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(dySalesOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param dySalesOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/dysalesorders")
  public XfR save(@RequestBody DySalesOrder dySalesOrder) {
     return XfR.ok(dySalesOrderServiceImpl.save(dySalesOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param dySalesOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/dysalesorders/{id}")
  public XfR putUpdate(@RequestBody DySalesOrder dySalesOrder,@PathVariable Long id) {
      dySalesOrder.setId(id);
      return XfR.ok(dySalesOrderServiceImpl.updateById(dySalesOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param dySalesOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/dysalesorders/{id}")
  public XfR patchUpdate(@RequestBody DySalesOrder dySalesOrder,@PathVariable Long id) {
      DySalesOrder updySalesOrder = dySalesOrderServiceImpl.getById(id);
      if(updySalesOrder != null){
        updySalesOrder = ObjectCopyUtils.copyProperties(dySalesOrder,updySalesOrder,true);
      }
      return XfR.ok(dySalesOrderServiceImpl.updateById(updySalesOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/dysalesorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(dySalesOrderServiceImpl.removeById(id));
  }

  @PostMapping("/dysalesorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "dy_sales_order");
     params.put("request", condition);

     return XfR.ok(dySalesOrderServiceImpl.querys(params));
  }

}
