package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.JkyOmsOrder;
import com.xforceplus.policymanagement.service.IJkyOmsOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-26
 */
@RestController
public class JkyOmsOrderController {

  @Autowired
  private IJkyOmsOrderService jkyOmsOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param jkyOmsOrder ${table.comment}
   * @return
   */
  @GetMapping("/jkyomsorders" )
  public XfR getJkyOmsOrders(XfPage page, JkyOmsOrder jkyOmsOrder) {
    return XfR.ok(jkyOmsOrderServiceImpl.page(page, Wrappers.query(jkyOmsOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/jkyomsorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(jkyOmsOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param jkyOmsOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/jkyomsorders")
  public XfR save(@RequestBody JkyOmsOrder jkyOmsOrder) {
     return XfR.ok(jkyOmsOrderServiceImpl.save(jkyOmsOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param jkyOmsOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/jkyomsorders/{id}")
  public XfR putUpdate(@RequestBody JkyOmsOrder jkyOmsOrder,@PathVariable Long id) {
      jkyOmsOrder.setId(id);
      return XfR.ok(jkyOmsOrderServiceImpl.updateById(jkyOmsOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param jkyOmsOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/jkyomsorders/{id}")
  public XfR patchUpdate(@RequestBody JkyOmsOrder jkyOmsOrder,@PathVariable Long id) {
      JkyOmsOrder upjkyOmsOrder = jkyOmsOrderServiceImpl.getById(id);
      if(upjkyOmsOrder != null){
        upjkyOmsOrder = ObjectCopyUtils.copyProperties(jkyOmsOrder,upjkyOmsOrder,true);
      }
      return XfR.ok(jkyOmsOrderServiceImpl.updateById(upjkyOmsOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/jkyomsorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(jkyOmsOrderServiceImpl.removeById(id));
  }

  @PostMapping("/jkyomsorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "jky_oms_order");
     params.put("request", condition);

     return XfR.ok(jkyOmsOrderServiceImpl.querys(params));
  }

}
