package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.PddAfterSale;
import com.xforceplus.policymanagement.service.IPddAfterSaleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-26
 */
@RestController
public class PddAfterSaleController {

  @Autowired
  private IPddAfterSaleService pddAfterSaleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pddAfterSale ${table.comment}
   * @return
   */
  @GetMapping("/pddaftersales" )
  public XfR getPddAfterSales(XfPage page, PddAfterSale pddAfterSale) {
    return XfR.ok(pddAfterSaleServiceImpl.page(page, Wrappers.query(pddAfterSale)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/pddaftersales/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(pddAfterSaleServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param pddAfterSale ${table.comment}
   * @return XfR
   */
  @PostMapping("/pddaftersales")
  public XfR save(@RequestBody PddAfterSale pddAfterSale) {
     return XfR.ok(pddAfterSaleServiceImpl.save(pddAfterSale));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param pddAfterSale ${table.comment}
   * @return XfR
   */
  @PutMapping("/pddaftersales/{id}")
  public XfR putUpdate(@RequestBody PddAfterSale pddAfterSale,@PathVariable Long id) {
      pddAfterSale.setId(id);
      return XfR.ok(pddAfterSaleServiceImpl.updateById(pddAfterSale));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param pddAfterSale ${table.comment}
   * @return XfR
   */
  @PatchMapping("/pddaftersales/{id}")
  public XfR patchUpdate(@RequestBody PddAfterSale pddAfterSale,@PathVariable Long id) {
      PddAfterSale uppddAfterSale = pddAfterSaleServiceImpl.getById(id);
      if(uppddAfterSale != null){
        uppddAfterSale = ObjectCopyUtils.copyProperties(pddAfterSale,uppddAfterSale,true);
      }
      return XfR.ok(pddAfterSaleServiceImpl.updateById(uppddAfterSale));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pddaftersales/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(pddAfterSaleServiceImpl.removeById(id));
  }

  @PostMapping("/pddaftersales/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pdd_after_sale");
     params.put("request", condition);

     return XfR.ok(pddAfterSaleServiceImpl.querys(params));
  }

}
