package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.PddCheck;
import com.xforceplus.policymanagement.service.IPddCheckService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 拼多多账单前端控制器
 *
 * @author ultraman
 * @date 2024-11-26
 */
@RestController
public class PddCheckController {

  @Autowired
  private IPddCheckService pddCheckServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pddCheck 拼多多账单
   * @return
   */
  @GetMapping("/pddchecks" )
  public XfR getPddChecks(XfPage page, PddCheck pddCheck) {
    return XfR.ok(pddCheckServiceImpl.page(page, Wrappers.query(pddCheck)));
  }

  /**
   * 通过id查询拼多多账单
   * @param  id
   * @return XfR
   */
  @GetMapping("/pddchecks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(pddCheckServiceImpl.getById(id));
  }

  /**
   * 新增拼多多账单
   * @param pddCheck 拼多多账单
   * @return XfR
   */
  @PostMapping("/pddchecks")
  public XfR save(@RequestBody PddCheck pddCheck) {
     return XfR.ok(pddCheckServiceImpl.save(pddCheck));
  }

  /**
   * 修改-传入修改后的全部数据拼多多账单
   * @param pddCheck 拼多多账单
   * @return XfR
   */
  @PutMapping("/pddchecks/{id}")
  public XfR putUpdate(@RequestBody PddCheck pddCheck,@PathVariable Long id) {
      pddCheck.setId(id);
      return XfR.ok(pddCheckServiceImpl.updateById(pddCheck));
  }

  /**
   * 修改-传入修改的数据拼多多账单
   * @param pddCheck 拼多多账单
   * @return XfR
   */
  @PatchMapping("/pddchecks/{id}")
  public XfR patchUpdate(@RequestBody PddCheck pddCheck,@PathVariable Long id) {
      PddCheck uppddCheck = pddCheckServiceImpl.getById(id);
      if(uppddCheck != null){
        uppddCheck = ObjectCopyUtils.copyProperties(pddCheck,uppddCheck,true);
      }
      return XfR.ok(pddCheckServiceImpl.updateById(uppddCheck));
  }

  /**
   * 通过id删除拼多多账单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pddchecks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(pddCheckServiceImpl.removeById(id));
  }

  @PostMapping("/pddchecks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pdd_check");
     params.put("request", condition);

     return XfR.ok(pddCheckServiceImpl.querys(params));
  }

}
