package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.SyncOrder;
import com.xforceplus.policymanagement.service.ISyncOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-26
 */
@RestController
public class SyncOrderController {

  @Autowired
  private ISyncOrderService syncOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param syncOrder ${table.comment}
   * @return
   */
  @GetMapping("/syncorders" )
  public XfR getSyncOrders(XfPage page, SyncOrder syncOrder) {
    return XfR.ok(syncOrderServiceImpl.page(page, Wrappers.query(syncOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/syncorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(syncOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param syncOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/syncorders")
  public XfR save(@RequestBody SyncOrder syncOrder) {
     return XfR.ok(syncOrderServiceImpl.save(syncOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param syncOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/syncorders/{id}")
  public XfR putUpdate(@RequestBody SyncOrder syncOrder,@PathVariable Long id) {
      syncOrder.setId(id);
      return XfR.ok(syncOrderServiceImpl.updateById(syncOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param syncOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/syncorders/{id}")
  public XfR patchUpdate(@RequestBody SyncOrder syncOrder,@PathVariable Long id) {
      SyncOrder upsyncOrder = syncOrderServiceImpl.getById(id);
      if(upsyncOrder != null){
        upsyncOrder = ObjectCopyUtils.copyProperties(syncOrder,upsyncOrder,true);
      }
      return XfR.ok(syncOrderServiceImpl.updateById(upsyncOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/syncorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(syncOrderServiceImpl.removeById(id));
  }

  @PostMapping("/syncorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sync_order");
     params.put("request", condition);

     return XfR.ok(syncOrderServiceImpl.querys(params));
  }

}
