package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.PddSalesOrder;
import com.xforceplus.policymanagement.service.IPddSalesOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-11-28
 */
@RestController
public class PddSalesOrderController {

  @Autowired
  private IPddSalesOrderService pddSalesOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pddSalesOrder ${table.comment}
   * @return
   */
  @GetMapping("/pddsalesorders" )
  public XfR getPddSalesOrders(XfPage page, PddSalesOrder pddSalesOrder) {
    return XfR.ok(pddSalesOrderServiceImpl.page(page, Wrappers.query(pddSalesOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/pddsalesorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(pddSalesOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param pddSalesOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/pddsalesorders")
  public XfR save(@RequestBody PddSalesOrder pddSalesOrder) {
     return XfR.ok(pddSalesOrderServiceImpl.save(pddSalesOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param pddSalesOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/pddsalesorders/{id}")
  public XfR putUpdate(@RequestBody PddSalesOrder pddSalesOrder,@PathVariable Long id) {
      pddSalesOrder.setId(id);
      return XfR.ok(pddSalesOrderServiceImpl.updateById(pddSalesOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param pddSalesOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/pddsalesorders/{id}")
  public XfR patchUpdate(@RequestBody PddSalesOrder pddSalesOrder,@PathVariable Long id) {
      PddSalesOrder uppddSalesOrder = pddSalesOrderServiceImpl.getById(id);
      if(uppddSalesOrder != null){
        uppddSalesOrder = ObjectCopyUtils.copyProperties(pddSalesOrder,uppddSalesOrder,true);
      }
      return XfR.ok(pddSalesOrderServiceImpl.updateById(uppddSalesOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pddsalesorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(pddSalesOrderServiceImpl.removeById(id));
  }

  @PostMapping("/pddsalesorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "pdd_sales_order");
     params.put("request", condition);

     return XfR.ok(pddSalesOrderServiceImpl.querys(params));
  }

}
