package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.WriteOffResultHistory;
import com.xforceplus.policymanagement.service.IWriteOffResultHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 应收回款核销履历前端控制器
 *
 * @author ultraman
 * @date 2024-11-28
 */
@RestController
public class WriteOffResultHistoryController {

  @Autowired
  private IWriteOffResultHistoryService writeOffResultHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param writeOffResultHistory 应收回款核销履历
   * @return
   */
  @GetMapping("/writeoffresulthistorys" )
  public XfR getWriteOffResultHistorys(XfPage page, WriteOffResultHistory writeOffResultHistory) {
    return XfR.ok(writeOffResultHistoryServiceImpl.page(page, Wrappers.query(writeOffResultHistory)));
  }

  /**
   * 通过id查询应收回款核销履历
   * @param  id
   * @return XfR
   */
  @GetMapping("/writeoffresulthistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(writeOffResultHistoryServiceImpl.getById(id));
  }

  /**
   * 新增应收回款核销履历
   * @param writeOffResultHistory 应收回款核销履历
   * @return XfR
   */
  @PostMapping("/writeoffresulthistorys")
  public XfR save(@RequestBody WriteOffResultHistory writeOffResultHistory) {
     return XfR.ok(writeOffResultHistoryServiceImpl.save(writeOffResultHistory));
  }

  /**
   * 修改-传入修改后的全部数据应收回款核销履历
   * @param writeOffResultHistory 应收回款核销履历
   * @return XfR
   */
  @PutMapping("/writeoffresulthistorys/{id}")
  public XfR putUpdate(@RequestBody WriteOffResultHistory writeOffResultHistory,@PathVariable Long id) {
      writeOffResultHistory.setId(id);
      return XfR.ok(writeOffResultHistoryServiceImpl.updateById(writeOffResultHistory));
  }

  /**
   * 修改-传入修改的数据应收回款核销履历
   * @param writeOffResultHistory 应收回款核销履历
   * @return XfR
   */
  @PatchMapping("/writeoffresulthistorys/{id}")
  public XfR patchUpdate(@RequestBody WriteOffResultHistory writeOffResultHistory,@PathVariable Long id) {
      WriteOffResultHistory upwriteOffResultHistory = writeOffResultHistoryServiceImpl.getById(id);
      if(upwriteOffResultHistory != null){
        upwriteOffResultHistory = ObjectCopyUtils.copyProperties(writeOffResultHistory,upwriteOffResultHistory,true);
      }
      return XfR.ok(writeOffResultHistoryServiceImpl.updateById(upwriteOffResultHistory));
  }

  /**
   * 通过id删除应收回款核销履历
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/writeoffresulthistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(writeOffResultHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/writeoffresulthistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "write_off_result_history");
     params.put("request", condition);

     return XfR.ok(writeOffResultHistoryServiceImpl.querys(params));
  }

}
