package com.xforceplus.policymanagement.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.policymanagement.entity.ReceivableSalesOrder;
import com.xforceplus.policymanagement.service.IReceivableSalesOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-04
 */
@RestController
public class ReceivableSalesOrderController {

  @Autowired
  private IReceivableSalesOrderService receivableSalesOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param receivableSalesOrder ${table.comment}
   * @return
   */
  @GetMapping("/receivablesalesorders" )
  public XfR getReceivableSalesOrders(XfPage page, ReceivableSalesOrder receivableSalesOrder) {
    return XfR.ok(receivableSalesOrderServiceImpl.page(page, Wrappers.query(receivableSalesOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/receivablesalesorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(receivableSalesOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param receivableSalesOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/receivablesalesorders")
  public XfR save(@RequestBody ReceivableSalesOrder receivableSalesOrder) {
     return XfR.ok(receivableSalesOrderServiceImpl.save(receivableSalesOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param receivableSalesOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/receivablesalesorders/{id}")
  public XfR putUpdate(@RequestBody ReceivableSalesOrder receivableSalesOrder,@PathVariable Long id) {
      receivableSalesOrder.setId(id);
      return XfR.ok(receivableSalesOrderServiceImpl.updateById(receivableSalesOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param receivableSalesOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/receivablesalesorders/{id}")
  public XfR patchUpdate(@RequestBody ReceivableSalesOrder receivableSalesOrder,@PathVariable Long id) {
      ReceivableSalesOrder upreceivableSalesOrder = receivableSalesOrderServiceImpl.getById(id);
      if(upreceivableSalesOrder != null){
        upreceivableSalesOrder = ObjectCopyUtils.copyProperties(receivableSalesOrder,upreceivableSalesOrder,true);
      }
      return XfR.ok(receivableSalesOrderServiceImpl.updateById(upreceivableSalesOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/receivablesalesorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(receivableSalesOrderServiceImpl.removeById(id));
  }

  @PostMapping("/receivablesalesorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "receivable_sales_order");
     params.put("request", condition);

     return XfR.ok(receivableSalesOrderServiceImpl.querys(params));
  }

}
